/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Random;
import net.codestory.http.Configuration;
import net.codestory.http.Payload;
import net.codestory.http.errors.ErrorPage;
import net.codestory.http.routes.Match;
import net.codestory.http.routes.RouteCollection;

public class WebServer {
    private final HttpServer server;
    private final RouteCollection routes = new RouteCollection();
    private Configuration lastConfiguration;

    public WebServer() {
        try {
            this.server = HttpServer.create();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to create http server", e);
        }
    }

    public static void main(String[] args) throws Exception {
        new WebServer().start(8080);
    }

    public WebServer configure(Configuration configuration) {
        this.routes.reset();
        configuration.configure(this.routes);
        if (this.devMode()) {
            this.lastConfiguration = configuration;
        }
        return this;
    }

    public WebServer startOnRandomPort() {
        Random random = new Random();
        for (int i = 0; i < 20; ++i) {
            try {
                int port = 8183 + random.nextInt(1000);
                this.start(port);
                return this;
            }
            catch (Exception e) {
                System.err.println("Unable to bind server: " + e);
                continue;
            }
        }
        throw new IllegalStateException("Unable to start server");
    }

    public WebServer start(int port) {
        try {
            this.server.bind(new InetSocketAddress(port), 0);
            this.server.createContext("/", this::onRequest);
            this.server.start();
            System.out.println("Server started on port " + port);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to bind the web server on port " + port);
        }
        return this;
    }

    public int port() {
        return this.server.getAddress().getPort();
    }

    public void reset() {
        this.lastConfiguration = null;
        this.routes.reset();
    }

    public void stop() {
        this.server.stop(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onRequest(HttpExchange exchange) {
        try {
            this.hotReloadConfigurationInDevMode();
            this.applyRoutes(exchange);
        }
        catch (Exception e) {
            System.out.println("Error " + e);
            e.printStackTrace();
            try {
                this.onError(e, exchange);
            }
            catch (Exception ioe) {
                System.out.println("Unable to server an error page " + ioe);
                ioe.printStackTrace();
            }
        }
        finally {
            exchange.close();
        }
    }

    protected void applyRoutes(HttpExchange exchange) throws IOException {
        Match match = this.routes.apply(exchange);
        if (match != Match.OK) {
            this.onPageNotFound(match, exchange);
        }
    }

    protected void onPageNotFound(Match match, HttpExchange exchange) throws IOException {
        if (match == Match.WRONG_METHOD) {
            this.errorPage(405, null).writeTo(exchange);
        } else {
            this.errorPage(404, null).writeTo(exchange);
        }
    }

    protected void onError(Exception e, HttpExchange exchange) throws IOException {
        if (this.devMode()) {
            this.errorPage(500, e).writeTo(exchange);
        } else {
            this.errorPage(500, null).writeTo(exchange);
        }
    }

    protected Payload errorPage(int code, Exception e) throws IOException {
        return new ErrorPage(code, e).payload();
    }

    protected boolean devMode() {
        return !Boolean.getBoolean("PROD_MODE");
    }

    protected void hotReloadConfigurationInDevMode() {
        if (this.lastConfiguration != null) {
            System.out.println("Reloading configuration");
            this.configure(this.lastConfiguration);
        }
    }
}

