/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http;

import net.codestory.http.io.Strings;

public class UriParser {
    private final String[] patternParts;
    private final int paramsCount;

    public UriParser(String uriPattern) {
        this.patternParts = UriParser.parts(uriPattern);
        this.paramsCount = UriParser.paramsCount(uriPattern);
    }

    public String[] params(String uri) {
        String[] uriParts = UriParser.parts(uri);
        String[] params = new String[this.paramsCount];
        int index = 0;
        for (int i = 0; i < this.patternParts.length; ++i) {
            if (!this.patternParts[i].startsWith(":")) continue;
            params[index++] = uriParts[i];
        }
        return params;
    }

    public boolean matches(String uri) {
        String[] uriParts = UriParser.parts(uri);
        if (this.patternParts.length != uriParts.length) {
            return false;
        }
        for (int i = 0; i < this.patternParts.length; ++i) {
            if (this.patternParts[i].startsWith(":") || this.patternParts[i].equals(uriParts[i])) continue;
            return false;
        }
        int lastPart = this.patternParts.length - 1;
        return !this.patternParts[lastPart].startsWith(":") || !uriParts[lastPart].isEmpty();
    }

    static String[] parts(String uri) {
        return uri.split("[/]", -1);
    }

    public static int paramsCount(String uriPattern) {
        return Strings.countMatches(uriPattern, "/:");
    }
}

