/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http;

import com.google.gson.Gson;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import net.codestory.http.compilers.Compiler;
import net.codestory.http.io.InputStreams;
import net.codestory.http.io.Resources;
import net.codestory.http.templating.Template;
import net.codestory.http.types.ContentTypes;

public class Payload {
    private final String contentType;
    private final Object content;
    private final int code;
    private final Headers headers;

    public Payload(Object content) {
        this(null, content);
    }

    public Payload(String contentType, Object content) {
        this(contentType, content, 200);
    }

    public Payload(String contentType, Object content, int code) {
        this.contentType = contentType;
        this.content = content;
        this.code = code;
        this.headers = new Headers();
    }

    public static Payload wrap(Object payload) {
        return payload instanceof Payload ? (Payload)payload : new Payload(payload);
    }

    public static Payload seeOther(String url) {
        Payload payload = new Payload(null, null, 303);
        payload.headers.add("Location", url);
        return payload;
    }

    public static Payload movedPermanently(String url) {
        Payload payload = new Payload(null, null, 301);
        payload.headers.add("Location", url);
        return payload;
    }

    public int code() {
        return this.code;
    }

    public void writeTo(HttpExchange exchange) throws IOException {
        exchange.getResponseHeaders().putAll(this.headers);
        byte[] data = this.getData();
        if (data != null) {
            exchange.getResponseHeaders().add("Content-Type", this.getContentType());
            exchange.sendResponseHeaders(this.code, data.length);
            exchange.getResponseBody().write(data);
        } else {
            exchange.sendResponseHeaders(this.code, 0L);
        }
    }

    String getContentType() {
        if (this.contentType != null) {
            return this.contentType;
        }
        if (this.content instanceof File) {
            File file = (File)this.content;
            return ContentTypes.get(file.toPath());
        }
        if (this.content instanceof Path) {
            Path path = (Path)this.content;
            return ContentTypes.get(path);
        }
        if (this.content instanceof byte[]) {
            return "application/octet-stream";
        }
        if (this.content instanceof InputStream) {
            return "application/octet-stream";
        }
        if (this.content instanceof String) {
            return "text/html";
        }
        return "application/json";
    }

    byte[] getData() throws IOException {
        if (this.content == null) {
            return null;
        }
        if (this.content instanceof File) {
            return Payload.forPath(((File)this.content).toPath());
        }
        if (this.content instanceof Path) {
            return Payload.forPath((Path)this.content);
        }
        if (this.content instanceof byte[]) {
            return (byte[])this.content;
        }
        if (this.content instanceof String) {
            return Payload.forString((String)this.content);
        }
        if (this.content instanceof InputStream) {
            return Payload.forInputStream((InputStream)this.content);
        }
        return Payload.forString(new Gson().toJson(this.content));
    }

    private static byte[] forString(String value) {
        return value.getBytes(StandardCharsets.UTF_8);
    }

    private static byte[] forInputStream(InputStream stream) throws IOException {
        return InputStreams.readBytes(stream);
    }

    private static byte[] forPath(Path path) throws IOException {
        if (ContentTypes.is_binary(path)) {
            return Resources.readBytes(path);
        }
        if (!ContentTypes.support_templating(path)) {
            String content = Resources.read(path, StandardCharsets.UTF_8);
            return Payload.forString(Compiler.compile(path, content));
        }
        return Payload.forString(new Template(path).render());
    }
}

