/*
 * Decompiled with CFR 0.152.
 */
package net.codestory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.StringJoiner;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

@FunctionalInterface
public interface Fluent<T>
extends Iterable<T> {
    public Stream<T> stream();

    public static <T> Fluent<T> of() {
        return Stream::empty;
    }

    @SafeVarargs
    public static <T> Fluent<T> of(T ... values) {
        Objects.requireNonNull(values);
        return () -> Stream.of(values);
    }

    public static Fluent<Integer> of(int[] values) {
        Objects.requireNonNull(values);
        return () -> IntStream.of(values).boxed();
    }

    public static Fluent<Double> of(double[] values) {
        Objects.requireNonNull(values);
        return () -> DoubleStream.of(values).boxed();
    }

    public static Fluent<Long> of(long[] values) {
        Objects.requireNonNull(values);
        return () -> LongStream.of(values).boxed();
    }

    public static <T> Fluent<T> of(Iterable<T> values) {
        Objects.requireNonNull(values);
        return values instanceof Fluent ? (Fluent<T>)values : () -> StreamSupport.stream(values.spliterator(), false);
    }

    public static <T> Fluent<T> of(Iterator<T> values) {
        Objects.requireNonNull(values);
        return () -> StreamSupport.stream(Spliterators.spliteratorUnknownSize(values, 0), false);
    }

    public static <T> Fluent<T> of(Stream<T> stream) {
        Objects.requireNonNull(stream);
        return () -> stream;
    }

    public static Fluent<String> ofChars(final String text) {
        Objects.requireNonNull(text);
        return Fluent.of(Stream.generate(new Supplier<String>(){
            int index = 0;

            @Override
            public String get() {
                return text.substring(this.index, ++this.index);
            }
        })).limit(text.length());
    }

    public static Fluent<String> split(String text, String regex) {
        Objects.requireNonNull(text);
        Objects.requireNonNull(regex);
        return Fluent.of(text.split(regex));
    }

    @Override
    default public void forEach(Consumer<? super T> action) {
        Objects.requireNonNull(action);
        this.stream().forEach(action);
    }

    default public <R> Fluent<R> map(Function<? super T, ? extends R> transform) {
        Objects.requireNonNull(transform);
        return () -> this.stream().map(transform);
    }

    default public IntStream mapToInt(ToIntFunction<? super T> transform) {
        Objects.requireNonNull(transform);
        return this.stream().mapToInt(transform);
    }

    default public LongStream mapToLong(ToLongFunction<? super T> transform) {
        Objects.requireNonNull(transform);
        return this.stream().mapToLong(transform);
    }

    default public DoubleStream mapToDouble(ToDoubleFunction<? super T> transform) {
        Objects.requireNonNull(transform);
        return this.stream().mapToDouble(transform);
    }

    default public IntStream flatMapToInt(Function<? super T, ? extends IntStream> transform) {
        Objects.requireNonNull(transform);
        return this.stream().flatMapToInt(transform);
    }

    default public LongStream flatMapToLong(Function<? super T, ? extends LongStream> transform) {
        Objects.requireNonNull(transform);
        return this.stream().flatMapToLong(transform);
    }

    default public DoubleStream flatMapToDouble(Function<? super T, ? extends DoubleStream> transform) {
        Objects.requireNonNull(transform);
        return this.stream().flatMapToDouble(transform);
    }

    default public Fluent<T> filter(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        return () -> this.stream().filter(predicate);
    }

    default public Fluent<T> exclude(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        return () -> this.stream().filter(predicate.negate());
    }

    default public <R> Fluent<R> filter(Class<R> type) {
        Objects.requireNonNull(type);
        return this.filter((? super T value) -> type.isInstance(value));
    }

    default public long size() {
        return this.stream().count();
    }

    default public long count(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        return this.stream().filter(predicate).count();
    }

    default public Optional<T> first() {
        return this.stream().findFirst();
    }

    default public Optional<T> any() {
        return this.stream().findAny();
    }

    default public Fluent<T> skip(long n) {
        return () -> this.stream().skip(n);
    }

    default public Optional<T> firstMatch(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        return this.stream().filter(predicate).findFirst();
    }

    default public Optional<T> last() {
        return this.stream().reduce((l, r) -> r);
    }

    default public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    default public String join(CharSequence delimiter) {
        Objects.requireNonNull(delimiter);
        StringJoiner joiner = new StringJoiner(delimiter);
        this.forEach(value -> joiner.add(String.valueOf(value)));
        return joiner.toString();
    }

    default public String join() {
        return this.join("");
    }

    default public boolean contains(Object element) {
        return this.stream().anyMatch(Predicate.isEqual(element));
    }

    default public int indexOf(Object element) {
        int index = 0;
        for (T value : this) {
            if (Objects.equals(value, element)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    default public T[] toArray(IntFunction<T[]> generator) {
        Objects.requireNonNull(generator);
        return this.stream().toArray(generator);
    }

    default public List<T> toList() {
        return this.copyInto(new ArrayList());
    }

    default public List<T> toSortedList(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator);
        List list = this.copyInto(new ArrayList());
        Collections.sort(list, comparator);
        return list;
    }

    default public SortedSet<T> toSortedSet(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator);
        return this.copyInto(new TreeSet<T>(comparator));
    }

    default public Set<T> toSet() {
        return this.copyInto(new HashSet());
    }

    default public boolean anyMatch(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        return this.stream().anyMatch(predicate);
    }

    default public boolean allMatch(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        return this.stream().allMatch(predicate);
    }

    default public boolean noneMatch(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        return this.stream().noneMatch(predicate);
    }

    default public <R, A> R collect(Collector<? super T, A, ? extends R> collector) {
        Objects.requireNonNull(collector);
        return this.stream().collect(collector);
    }

    default public Fluent<T> limit(int limitSize) {
        if (limitSize < 0) {
            throw new IllegalArgumentException("limit is negative");
        }
        return () -> this.stream().limit(limitSize);
    }

    default public Fluent<T> cycle() {
        return () -> Stream.generate(() -> this.stream()).flatMap((? super T s) -> s);
    }

    default public void forEachWithIndex(BiConsumer<Integer, T> consumer) {
        Objects.requireNonNull(consumer);
        if (this.isParallel()) {
            AtomicInteger index = new AtomicInteger(0);
            this.forEach(value -> consumer.accept(index.getAndIncrement(), (Integer)value));
        } else {
            int index = 0;
            for (T value2 : this) {
                consumer.accept(index++, (Integer)value2);
            }
        }
    }

    default public Fluent<T> peek(Consumer<? super T> action) {
        Objects.requireNonNull(action);
        return () -> this.stream().peek(action);
    }

    default public void forEachOrdered(Consumer<? super T> action) {
        Objects.requireNonNull(action);
        this.stream().forEachOrdered(action);
    }

    @Override
    default public Iterator<T> iterator() {
        return this.stream().iterator();
    }

    @Override
    default public Spliterator<T> spliterator() {
        return this.stream().spliterator();
    }

    default public boolean isParallel() {
        return this.stream().isParallel();
    }

    default public Fluent<T> sequential() {
        return () -> (Stream)this.stream().sequential();
    }

    default public Fluent<T> unordered() {
        return () -> (Stream)this.stream().unordered();
    }

    default public IntStream intStream(ToIntFunction<? super T> mapper) {
        Objects.requireNonNull(mapper);
        return this.stream().mapToInt(mapper);
    }

    default public LongStream longStream(ToLongFunction<? super T> mapper) {
        Objects.requireNonNull(mapper);
        return this.stream().mapToLong(mapper);
    }

    default public DoubleStream doubleStream(ToDoubleFunction<? super T> mapper) {
        Objects.requireNonNull(mapper);
        return this.stream().mapToDouble(mapper);
    }

    default public Optional<T> min(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator);
        return this.stream().min(comparator);
    }

    default public Optional<T> max(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator);
        return this.stream().max(comparator);
    }

    default public <C extends Collection<T>> C copyInto(C collection) {
        Objects.requireNonNull(collection);
        return (C)this.stream().collect(Collectors.toCollection(() -> collection));
    }

    default public T reduce(T identity, BinaryOperator<T> accumulator) {
        Objects.requireNonNull(accumulator);
        return this.stream().reduce(identity, accumulator);
    }

    default public Optional<T> reduce(BinaryOperator<T> accumulator) {
        Objects.requireNonNull(accumulator);
        return this.stream().reduce(accumulator);
    }

    default public <K> Map<K, T> uniqueIndex(Function<? super T, K> toKey) {
        Objects.requireNonNull(toKey);
        HashMap map = new HashMap();
        this.forEach(value -> {
            Object key = toKey.apply(value);
            if (null != map.put(key, value)) {
                throw new IllegalArgumentException("Same key used twice" + key);
            }
        });
        return map;
    }

    default public <K> Map<K, List<T>> index(Function<? super T, K> toKey) {
        Objects.requireNonNull(toKey);
        HashMap multiMap = new HashMap();
        this.forEach(value -> {
            Object key = toKey.apply(value);
            List list = multiMap.computeIfAbsent(key, k -> new ArrayList());
            list.add(value);
        });
        return multiMap;
    }

    default public <V> Map<T, V> toMap(Function<? super T, V> toValue) {
        Objects.requireNonNull(toValue);
        HashMap map = new HashMap();
        this.forEach(key -> {
            Object value = toValue.apply(key);
            if (null != map.put(key, value)) {
                throw new IllegalArgumentException("Same key used twice" + key);
            }
        });
        return map;
    }

    default public <K, V> Map<K, V> toMap(Function<? super T, K> toKey, Function<? super T, V> toValue) {
        Objects.requireNonNull(toKey);
        Objects.requireNonNull(toValue);
        HashMap map = new HashMap();
        this.forEach(item -> {
            Object value;
            Object key = toKey.apply(item);
            if (null != map.put(key, value = toValue.apply(item))) {
                throw new IllegalArgumentException("Same key used twice" + key);
            }
        });
        return map;
    }

    default public T get(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index is negative");
        }
        int current = 0;
        for (T next : this) {
            if (current == index) {
                return next;
            }
            ++current;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    default public <V, L extends List<V>> Fluent<V> flatMap(Function<? super T, L> toList) {
        Objects.requireNonNull(toList);
        return () -> {
            Function<List, Stream> toStream = l -> l.stream();
            Function toListAndThenToStream = toList.andThen(toStream);
            return this.stream().flatMap(toListAndThenToStream);
        };
    }

    default public Fluent<T> parallel() {
        return () -> (Stream)this.stream().parallel();
    }

    default public Fluent<T> sorted() {
        return () -> this.stream().sorted();
    }

    default public Fluent<T> distinct() {
        return () -> this.stream().distinct();
    }

    default public Fluent<T> sorted(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator);
        return () -> this.stream().sorted(comparator);
    }

    default public Fluent<T> reversed(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator);
        return () -> this.stream().sorted(comparator.reversed());
    }

    default public <C extends Comparable<? super C>> Fluent<T> sortedOn(Function<? super T, C> comparator) {
        Objects.requireNonNull(comparator);
        return () -> this.stream().sorted((l, r) -> ((Comparable)comparator.apply(l)).compareTo(comparator.apply(r)));
    }

    default public <C extends Comparable<? super C>> Fluent<T> reversedOn(Function<? super T, C> comparator) {
        Objects.requireNonNull(comparator);
        return () -> this.stream().sorted((l, r) -> ((Comparable)comparator.apply(r)).compareTo(comparator.apply(l)));
    }

    default public Fluent<T> concat(T ... values) {
        Objects.requireNonNull(values);
        return () -> Stream.concat(this.stream(), Stream.of(values));
    }

    default public Fluent<T> concat(Iterable<T> values) {
        Objects.requireNonNull(values);
        return () -> Stream.concat(this.stream(), StreamSupport.stream(values.spliterator(), false));
    }

    default public T getOnlyElement() {
        return this.first().get();
    }

    default public Fluent<T> notNulls() {
        return this.filter((? super T v) -> v != null);
    }

    default public <K> Map<K, List<T>> groupBy(Function<? super T, ? extends K> classifier) {
        Objects.requireNonNull(classifier);
        return this.stream().collect(Collectors.groupingBy(classifier, HashMap::new, Collectors.toList()));
    }

    default public <K, M extends Map<K, List<T>>> Map<K, List<T>> groupBy(Function<? super T, ? extends K> classifier, Supplier<M> mapFactory) {
        Objects.requireNonNull(classifier);
        return (Map)this.stream().collect(Collectors.groupingBy(classifier, mapFactory, Collectors.toList()));
    }
}

