/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.rest;

import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpCookie;
import java.util.List;
import java.util.function.Function;

class RestResponse {
    private final CookieManager cookieManager;
    private final Response response;
    private String bodyAsString;

    private RestResponse(CookieManager cookieManager, Response response) {
        this.cookieManager = cookieManager;
        this.response = response;
    }

    static RestResponse call(String url, Function<OkHttpClient, OkHttpClient> configureClient, Function<Request.Builder, Request.Builder> configureRequest) throws IOException {
        CookieManager cookieManager = new CookieManager();
        cookieManager.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
        Request.Builder request = configureRequest.apply(new Request.Builder().url(url));
        OkHttpClient client = configureClient.apply(new OkHttpClient().setCookieHandler((CookieHandler)cookieManager));
        Response response = client.newCall(request.build()).execute();
        return new RestResponse(cookieManager, response);
    }

    public int code() {
        return this.response.code();
    }

    public String bodyAsString() {
        if (this.bodyAsString == null) {
            try {
                this.bodyAsString = this.response.body().string();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to read response as String", e);
            }
        }
        return this.bodyAsString;
    }

    public String contentType() {
        return this.header("Content-Type");
    }

    public String header(String name) {
        return this.response.header(name);
    }

    public String cookie(String name) {
        List<HttpCookie> cookies = this.cookieManager.getCookieStore().getCookies();
        return cookies.stream().filter(cookie -> cookie.getName().equals(name)).findFirst().map(cookie -> cookie.getValue()).orElse(null);
    }
}

