/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.rest;

import net.codestory.rest.RestAssert;
import net.codestory.rest.misc.PostBody;

public interface FluentRestTest {
    public int port();

    default public String baseUrl() {
        return "http://localhost:" + this.port();
    }

    default public RestAssert get(String path) {
        return new RestAssert(this.baseUrl() + path);
    }

    default public RestAssert delete(String path) {
        return this.get(path).withRequest(request -> request.delete());
    }

    default public RestAssert head(String path) {
        return this.get(path).withRequest(request -> request.head());
    }

    default public RestAssert post(String path) {
        return this.get(path).withRequest(request -> request.post(PostBody.empty()));
    }

    default public RestAssert post(String path, String body) {
        return this.get(path).withRequest(request -> request.post(PostBody.json(body)));
    }

    default public RestAssert post(String path, String firstParameterName, Object firstParameterValue, Object ... parameterNameValuePairs) {
        return this.get(path).withRequest(request -> request.post(PostBody.form(firstParameterName, firstParameterValue, parameterNameValuePairs)));
    }

    default public RestAssert put(String path) {
        return this.get(path).withRequest(request -> request.put(PostBody.empty()));
    }

    default public RestAssert put(String path, String body) {
        return this.get(path).withRequest(request -> request.put(PostBody.json(body)));
    }

    default public RestAssert put(String path, String firstParameterName, Object firstParameterValue, Object ... parameterNameValuePairs) {
        return this.get(path).withRequest(request -> request.put(PostBody.form(firstParameterName, firstParameterValue, parameterNameValuePairs)));
    }

    default public RestAssert options(String path) {
        return this.get(path).withRequest(request -> request.method("OPTIONS", null));
    }
}

