/*
 * Decompiled with CFR 0.152.
 */
package net.cnri.servletcontainer;

import java.security.cert.X509Certificate;
import javax.net.ssl.SSLException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public interface TlsRenegotiationRequestor {
    public boolean isWantingTlsRenegotiation(Boolean var1, boolean var2);

    public boolean isNeedClientAuth();

    public void requestTlsRenegotiation(HttpServletRequest var1, HttpServletResponse var2, Boolean var3) throws SSLException;

    public boolean isRequestSupportsTlsRenegotiation();

    public static boolean isProbablyWantingTlsRenegotiation(HttpServletRequest req, Boolean wantClientAuth, boolean force) {
        if (force) {
            return true;
        }
        if (wantClientAuth == null) {
            return false;
        }
        if (wantClientAuth.booleanValue()) {
            return TlsRenegotiationRequestor.extractCertificate(req) == null;
        }
        return TlsRenegotiationRequestor.extractCertificate(req) != null;
    }

    public static X509Certificate extractCertificate(HttpServletRequest request) {
        X509Certificate[] certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
        if (null != certs && certs.length > 0) {
            return certs[0];
        }
        return null;
    }
}

