package net.cnri.servletcontainer;

import javax.net.ssl.SSLException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.security.cert.X509Certificate;

public interface TlsRenegotiationRequestor {
    boolean isWantingTlsRenegotiation(Boolean wantClientAuth, boolean force);
    boolean isNeedClientAuth();
    void requestTlsRenegotiation(HttpServletRequest req, HttpServletResponse resp, Boolean wantClientAuth) throws SSLException;
    boolean isRequestSupportsTlsRenegotiation();

    static boolean isProbablyWantingTlsRenegotiation(HttpServletRequest req, Boolean wantClientAuth, boolean force) {
        if (force) return true;
        if (wantClientAuth == null) return false;
        if (wantClientAuth.booleanValue()) {
            return extractCertificate(req) == null;
        } else {
            return extractCertificate(req) != null;
        }
    }

    static X509Certificate extractCertificate(HttpServletRequest request) {
        X509Certificate[] certs = (X509Certificate[]) request.getAttribute("javax.servlet.request.X509Certificate");
        if (null != certs && certs.length > 0) {
            return certs[0];
        }
        return null;
    }
}