/*
 * Decompiled with CFR 0.152.
 */
package net.cnri.util.javascript.nashorn;

import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;

public class SequenceReader
extends Reader {
    private final Reader[] readers;
    int index;

    public SequenceReader(Reader ... readers) {
        this.readers = readers;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.index >= this.readers.length) {
            return -1;
        }
        while (this.index < this.readers.length) {
            int read = this.readers[this.index].read(cbuf, off, len);
            if (read >= 0) {
                return read;
            }
            this.readers[this.index].close();
            ++this.index;
        }
        return -1;
    }

    @Override
    public int read(CharBuffer target) throws IOException {
        if (this.index >= this.readers.length) {
            return -1;
        }
        while (this.index < this.readers.length) {
            int read = this.readers[this.index].read(target);
            if (read >= 0) {
                return read;
            }
            this.readers[this.index].close();
            ++this.index;
        }
        return -1;
    }

    @Override
    public int read() throws IOException {
        if (this.index >= this.readers.length) {
            return -1;
        }
        while (this.index < this.readers.length) {
            int read = this.readers[this.index].read();
            if (read >= 0) {
                return read;
            }
            this.readers[this.index].close();
            ++this.index;
        }
        return -1;
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        if (this.index >= this.readers.length) {
            return -1;
        }
        while (this.index < this.readers.length) {
            int read = this.readers[this.index].read(cbuf);
            if (read >= 0) {
                return read;
            }
            this.readers[this.index].close();
            ++this.index;
        }
        return -1;
    }

    @Override
    public void close() throws IOException {
        IOException exception = null;
        while (this.index < this.readers.length) {
            try {
                this.readers[this.index].close();
            }
            catch (IOException e) {
                if (exception == null) {
                    exception = e;
                }
                exception.addSuppressed(e);
            }
            ++this.index;
        }
        if (exception != null) {
            throw exception;
        }
    }
}

