/*
 * Decompiled with CFR 0.152.
 */
package net.cnri.util.javascript.nashorn;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import jdk.nashorn.api.scripting.JSObject;
import jdk.nashorn.api.scripting.NashornException;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import net.cnri.util.javascript.nashorn.JavaScriptEventLoop;
import net.cnri.util.javascript.nashorn.JavaScriptRunner;

public class ScriptEngineAndCompilationCache {
    private static final String BUILTIN_COMPILED_SCRIPT_PREFIX = "cnri/_jse/";
    private final ScriptEngine scriptEngine;
    private final ConcurrentMap<String, CompiledScript> compilationCache;
    private final Map<String, Object> extraGlobals = new ConcurrentHashMap<String, Object>();
    private final Map<String, Map<String, String>> moduleResolveCache = new ConcurrentHashMap<String, Map<String, String>>();

    public ScriptEngineAndCompilationCache(ScriptEngine scriptEngine) {
        this.scriptEngine = scriptEngine;
        this.compilationCache = new ConcurrentHashMap<String, CompiledScript>();
        this.initialize();
    }

    private void initialize() {
        Object originalFilename = this.scriptEngine.get("javax.script.filename");
        try {
            this.initCompileResource("initialize.js");
            this.initCompileString("thrower.js", "function (reason) { throw reason; }");
            this.initCompileString("json.js", "JSON");
            this.initCompileResource("module.js");
            this.initCompileResource("logger-warn.js");
            this.initCompileResource("console.js");
            this.initCompileResource("timers.js");
            this.initCompileResource("process.js");
            this.initCompileResource("promise.js");
            this.initCompileResource("cnri-javascript-core-js-bundle.min.js");
        }
        catch (IOException | ScriptException e) {
            throw new AssertionError((Object)e);
        }
        finally {
            this.scriptEngine.put("javax.script.filename", originalFilename);
        }
    }

    private void initCompileString(String name, String script) throws ScriptException {
        this.scriptEngine.put("javax.script.filename", name);
        this.compilationCache.putIfAbsent(BUILTIN_COMPILED_SCRIPT_PREFIX + name, ((Compilable)((Object)this.scriptEngine)).compile(script));
    }

    public void put(String key, Object obj) {
        this.extraGlobals.put(key, obj);
    }

    private void initCompileResource(String name) throws ScriptException, IOException {
        try (InputStreamReader isr = new InputStreamReader(JavaScriptRunner.class.getResourceAsStream(name), StandardCharsets.UTF_8);){
            this.scriptEngine.put("javax.script.filename", name);
            this.compilationCache.putIfAbsent(BUILTIN_COMPILED_SCRIPT_PREFIX + name, ((Compilable)((Object)this.scriptEngine)).compile(isr));
        }
    }

    public synchronized void clearCache() {
        this.moduleResolveCache.clear();
        Iterator iter = this.compilationCache.keySet().iterator();
        while (iter.hasNext()) {
            if (((String)iter.next()).startsWith(BUILTIN_COMPILED_SCRIPT_PREFIX)) continue;
            iter.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CompiledScript compileAndCache(String name, String script) throws ScriptException {
        Object originalFilename = this.scriptEngine.get("javax.script.filename");
        try {
            this.scriptEngine.put("javax.script.filename", name);
            CompiledScript compiledScript = ((Compilable)((Object)this.scriptEngine)).compile(script);
            this.compilationCache.putIfAbsent(name, compiledScript);
            CompiledScript compiledScript2 = compiledScript;
            return compiledScript2;
        }
        finally {
            this.scriptEngine.put("javax.script.filename", originalFilename);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CompiledScript compileAndCache(String name, Reader script) throws ScriptException {
        Object originalFilename = this.scriptEngine.get("javax.script.filename");
        try {
            this.scriptEngine.put("javax.script.filename", name);
            CompiledScript compiledScript = ((Compilable)((Object)this.scriptEngine)).compile(script);
            this.compilationCache.putIfAbsent(name, compiledScript);
            CompiledScript compiledScript2 = compiledScript;
            return compiledScript2;
        }
        finally {
            this.scriptEngine.put("javax.script.filename", originalFilename);
        }
    }

    public ScriptEngine getScriptEngine() {
        return this.scriptEngine;
    }

    public CompiledScript getCompiledScript(String name) {
        return (CompiledScript)this.compilationCache.get(name);
    }

    public boolean hasCompiledScript(String name) {
        return this.compilationCache.containsKey(name);
    }

    public void initializeScriptContext(ScriptContext scriptContext) {
        try {
            scriptContext = scriptContext != null ? scriptContext : this.scriptEngine.getContext();
            ((CompiledScript)this.compilationCache.get("cnri/_jse/initialize.js")).eval(scriptContext);
            JSObject cnriJse = (JSObject)((JSObject)scriptContext.getAttribute("cnri")).getMember("_jse");
            cnriJse.setMember("threadLocalJavaScriptEventLoop", JavaScriptEventLoop.threadLocalJavaScriptEventLoop);
            ((CompiledScript)this.compilationCache.get("cnri/_jse/console.js")).eval(scriptContext);
            ((CompiledScript)this.compilationCache.get("cnri/_jse/timers.js")).eval(scriptContext);
            ((CompiledScript)this.compilationCache.get("cnri/_jse/process.js")).eval(scriptContext);
            ((CompiledScript)this.compilationCache.get("cnri/_jse/promise.js")).eval(scriptContext);
            ((CompiledScript)this.compilationCache.get("cnri/_jse/cnri-javascript-core-js-bundle.min.js")).eval(scriptContext);
            for (Map.Entry<String, Object> entry : this.extraGlobals.entrySet()) {
                scriptContext.setAttribute(entry.getKey(), entry.getValue(), 100);
            }
        }
        catch (ScriptException e) {
            throw new AssertionError((Object)e);
        }
    }

    public String getCachedModuleResolution(String parentFilename, String id) {
        String key;
        Map<String, String> subMap;
        if (parentFilename == null) {
            parentFilename = "/.";
        }
        if (id.startsWith("./") || id.startsWith("../") || id.startsWith("/")) {
            id = Paths.get(parentFilename, new String[0]).resolveSibling(id).normalize().toString();
            parentFilename = "/.";
        }
        if ((subMap = this.moduleResolveCache.get(key = this.getKeyFromParent(parentFilename))) == null) {
            return null;
        }
        return subMap.get(id);
    }

    public void cacheModuleResolution(String parentFilename, String id, String resolution) {
        if (resolution == null) {
            return;
        }
        if (parentFilename == null) {
            parentFilename = "/.";
        }
        if (id.startsWith("./") || id.startsWith("../") || id.startsWith("/")) {
            id = Paths.get(parentFilename, new String[0]).resolveSibling(id).normalize().toString();
            parentFilename = "/.";
        }
        String key = this.getKeyFromParent(parentFilename);
        Map subMap = this.moduleResolveCache.computeIfAbsent(key, s -> new ConcurrentHashMap());
        subMap.put(id, resolution);
    }

    private String getKeyFromParent(String parentFilename) {
        Path grandparentPath = Paths.get(parentFilename, new String[0]).getParent();
        if (grandparentPath == null) {
            return "/";
        }
        return grandparentPath.normalize().toString();
    }

    public JSObject newModule(ScriptContext scriptContext, JSObject parent, String filename, RequireModuleFunction requireModule, ResolveFunction resolve) {
        try {
            JSObject newModuleObjectBuilder = (JSObject)this.getCompiledScript("cnri/_jse/module.js").eval(scriptContext);
            return (JSObject)newModuleObjectBuilder.call(null, new Object[]{parent, filename, requireModule, resolve});
        }
        catch (ScriptException e) {
            throw new AssertionError((Object)e);
        }
    }

    public Object jsonParse(ScriptContext scriptContext, String json) {
        try {
            return ((ScriptObjectMirror)this.getCompiledScript("cnri/_jse/json.js").eval(scriptContext)).callMember("parse", new Object[]{json});
        }
        catch (ScriptException e) {
            throw new AssertionError((Object)e);
        }
    }

    public String jsonStringify(ScriptContext scriptContext, Object obj) {
        try {
            Object res = ((ScriptObjectMirror)this.getCompiledScript("cnri/_jse/json.js").eval(scriptContext)).callMember("stringify", new Object[]{obj});
            if (ScriptObjectMirror.isUndefined((Object)res)) {
                return null;
            }
            return (String)res;
        }
        catch (ScriptException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void loggerWarn(ScriptContext scriptContext, Thread thread, Throwable exception) {
        try {
            JSObject loggerWarn = (JSObject)this.getCompiledScript("cnri/_jse/logger-warn.js").eval(scriptContext);
            loggerWarn.call(null, new Object[]{thread, exception});
        }
        catch (ScriptException e) {
            throw new AssertionError((Object)e);
        }
    }

    public NashornException reasonToException(ScriptContext scriptContext, Object reason) {
        try {
            JSObject thrower = (JSObject)this.getCompiledScript("cnri/_jse/thrower.js").eval(scriptContext);
            thrower.call(null, new Object[]{reason});
            return null;
        }
        catch (ScriptException e) {
            throw new AssertionError((Object)e);
        }
        catch (NashornException ne) {
            if (reason instanceof Throwable) {
                if (ne == reason) {
                    return ne;
                }
                if (ne.getCause() == null) {
                    try {
                        ne.initCause((Throwable)reason);
                    }
                    catch (Exception ex) {
                        ne.addSuppressed((Throwable)reason);
                    }
                } else {
                    ne.addSuppressed((Throwable)reason);
                }
            }
            return ne;
        }
    }

    @FunctionalInterface
    public static interface RequireModuleFunction {
        public JSObject requireModule(JSObject var1, String var2);
    }

    @FunctionalInterface
    public static interface ResolveFunction {
        public String resolve(JSObject var1, String var2);
    }
}

