/*
 * Decompiled with CFR 0.152.
 */
package net.cnri.util.javascript.nashorn;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import jdk.nashorn.api.scripting.JSObject;
import jdk.nashorn.api.scripting.NashornException;
import net.cnri.util.javascript.nashorn.RequireLookup;
import net.cnri.util.javascript.nashorn.ScriptEngineAndCompilationCache;
import net.cnri.util.javascript.nashorn.SequenceReader;

public class ModuleSystem {
    private final ScriptEngineAndCompilationCache scriptEngineAndCompilationCache;
    private final ScriptContext scriptContext;
    private final JSObject moduleCache;
    private final RequireLookup requireLookup;
    private static final String MODULE_PREFIX = "function (exports, require, module, __filename, __dirname) {";
    private static final String MODULE_SUFFIX = "\n}";

    public ModuleSystem(ScriptEngineAndCompilationCache scriptEngineAndCompilationCache, ScriptContext scriptContext, JSObject moduleCache, RequireLookup requireLookup) {
        this.scriptEngineAndCompilationCache = scriptEngineAndCompilationCache;
        this.scriptContext = scriptContext;
        this.moduleCache = moduleCache;
        this.requireLookup = requireLookup;
    }

    private static String dirname(String s) {
        int lastSlash = s.lastIndexOf(47);
        if (lastSlash == -1) {
            return ".";
        }
        if (lastSlash == 0) {
            return "/";
        }
        return s.substring(0, lastSlash);
    }

    private static final String readFully(Reader reader) throws IOException {
        int r;
        StringBuilder sb = new StringBuilder();
        char[] buf = new char[8192];
        while ((r = reader.read(buf)) > 0) {
            sb.append(buf, 0, r);
        }
        return sb.toString();
    }

    private boolean moduleExists(String id) {
        if (this.moduleCache.hasMember(id)) {
            return true;
        }
        if (this.scriptEngineAndCompilationCache.hasCompiledScript(id)) {
            return true;
        }
        return this.requireLookup != null && this.requireLookup.exists(id);
    }

    public String resolve(JSObject parent, String id) {
        String parentFilename = parent == null ? "/." : (String)parent.getMember("filename");
        String cachedResolution = this.scriptEngineAndCompilationCache.getCachedModuleResolution(parentFilename, id);
        if (cachedResolution != null) {
            return cachedResolution;
        }
        String res = this.resolveUncached(parent, parentFilename, id);
        if (res == null) {
            return null;
        }
        this.scriptEngineAndCompilationCache.cacheModuleResolution(parentFilename, id, res);
        return res;
    }

    private String resolveUncached(JSObject parent, String parentFilename, String id) {
        String resolvedCoreModule = this.resolveFile(id);
        if (resolvedCoreModule != null) {
            return resolvedCoreModule;
        }
        try {
            Path parentFilepath = Paths.get(parentFilename, new String[0]);
            if (id.startsWith("./") || id.startsWith("../") || id.startsWith("/")) {
                String absoluteId = parentFilepath.resolveSibling(id).normalize().toString();
                String resolvedFile = this.resolveFile(absoluteId);
                if (resolvedFile != null) {
                    return resolvedFile;
                }
                resolvedFile = this.resolveDirectory(parent, absoluteId);
                if (resolvedFile != null) {
                    return resolvedFile;
                }
            } else {
                while ((parentFilepath = parentFilepath.getParent()) != null) {
                    if (parentFilepath.getFileName() != null && parentFilepath.getFileName().toString().equals("node_modules")) continue;
                    String absoluteId = parentFilepath.resolve("node_modules").resolve(id).normalize().toString();
                    String resolvedFile = this.resolveFile(absoluteId);
                    if (resolvedFile != null) {
                        return resolvedFile;
                    }
                    resolvedFile = this.resolveDirectory(parent, absoluteId);
                    if (resolvedFile == null) continue;
                    return resolvedFile;
                }
            }
            return null;
        }
        catch (NashornException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw this.scriptEngineAndCompilationCache.reasonToException(this.scriptContext, e);
        }
    }

    private String resolveFile(String absoluteId) {
        if (this.moduleExists(absoluteId)) {
            return absoluteId;
        }
        if (this.moduleExists(absoluteId + ".js")) {
            return absoluteId + ".js";
        }
        if (this.moduleExists(absoluteId + ".json")) {
            return absoluteId + ".json";
        }
        return null;
    }

    private String resolveDirectory(JSObject parent, String absoluteId) {
        String main = this.getMainFromPackageJson(parent, absoluteId);
        if (main != null) {
            String resolvedFile = this.resolveFile(Paths.get(absoluteId, new String[0]).resolve(main).normalize().toString());
            if (resolvedFile != null) {
                return resolvedFile;
            }
        } else {
            if (this.moduleExists(absoluteId + "/index.js")) {
                return absoluteId + "/index.js";
            }
            if (this.moduleExists(absoluteId + "/index.json")) {
                return absoluteId + "/index.json";
            }
        }
        return null;
    }

    private String getMainFromPackageJson(JSObject parent, String absoluteId) {
        Object mainObj;
        Object exports;
        JSObject packageJsonModule = this.getModule(parent, absoluteId + "/package.json");
        if (packageJsonModule != null && (exports = packageJsonModule.getMember("exports")) instanceof JSObject && (mainObj = ((JSObject)exports).getMember("main")) instanceof String) {
            return (String)mainObj;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JSObject getModule(JSObject parent, String filename) {
        Object module = this.moduleCache.getMember(filename);
        if (module instanceof JSObject) {
            return (JSObject)module;
        }
        CompiledScript compiledScript = this.scriptEngineAndCompilationCache.getCompiledScript(filename);
        if (compiledScript != null) {
            return this.getModuleFromCompiledScript(parent, filename, compiledScript);
        }
        try (Reader moduleContent = this.requireLookup == null ? null : this.requireLookup.getContent(filename);){
            if (moduleContent == null) return null;
            JSObject jSObject = this.requireModuleFromReader(parent, filename, moduleContent);
            return jSObject;
        }
        catch (IOException e) {
            throw this.scriptEngineAndCompilationCache.reasonToException(this.scriptContext, e);
        }
    }

    public JSObject requireModuleFromReader(JSObject parent, String filename, Reader moduleContent) {
        try {
            CompiledScript compiledScript;
            if (filename.endsWith(".json")) {
                String moduleContentString = ModuleSystem.readFully(moduleContent);
                return this.getModuleFromJson(parent, filename, moduleContentString);
            }
            try (SequenceReader wrappedModule = new SequenceReader(new StringReader(MODULE_PREFIX), moduleContent, new StringReader(MODULE_SUFFIX));){
                compiledScript = this.scriptEngineAndCompilationCache.compileAndCache(filename, wrappedModule);
            }
            catch (ScriptException e) {
                Throwable cause = e.getCause();
                if (cause instanceof NashornException) {
                    throw (NashornException)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw e;
            }
            return this.getModuleFromCompiledScript(parent, filename, compiledScript);
        }
        catch (NashornException e) {
            throw e;
        }
        catch (IOException | RuntimeException | ScriptException e) {
            throw this.scriptEngineAndCompilationCache.reasonToException(this.scriptContext, e);
        }
    }

    public JSObject requireModuleFromReaderInGlobalContext(JSObject parent, String filename, Reader moduleContent) {
        try {
            if (filename.endsWith(".json")) {
                String moduleContentString = ModuleSystem.readFully(moduleContent);
                return this.getModuleFromJson(parent, filename, moduleContentString);
            }
            JSObject module = this.newModule(parent, filename);
            this.moduleCache.setMember(filename, (Object)module);
            this.scriptContext.setAttribute("exports", module.getMember("exports"), 100);
            this.scriptContext.setAttribute("require", module.getMember("require"), 100);
            this.scriptContext.setAttribute("module", module, 100);
            this.scriptContext.setAttribute("__filename", filename, 100);
            this.scriptContext.setAttribute("__dirname", ModuleSystem.dirname(filename), 100);
            try {
                this.scriptEngineAndCompilationCache.getScriptEngine().eval(moduleContent, this.scriptContext);
            }
            catch (RuntimeException | ScriptException e) {
                this.moduleCache.removeMember(filename);
                throw e;
            }
            module.setMember("loaded", (Object)Boolean.TRUE);
            return module;
        }
        catch (NashornException e) {
            throw e;
        }
        catch (ScriptException e) {
            Throwable cause = e.getCause();
            if (cause instanceof NashornException) {
                throw (NashornException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw this.scriptEngineAndCompilationCache.reasonToException(this.scriptContext, e);
        }
        catch (IOException | RuntimeException e) {
            throw this.scriptEngineAndCompilationCache.reasonToException(this.scriptContext, e);
        }
    }

    public Object requireFromReader(JSObject parent, String filename, Reader reader) {
        JSObject module = this.requireModuleFromReader(parent, filename, reader);
        if (module == null) {
            return null;
        }
        return module.getMember("exports");
    }

    public Object requireFromReaderInGlobalContext(JSObject parent, String filename, Reader reader) {
        JSObject module = this.requireModuleFromReaderInGlobalContext(parent, filename, reader);
        if (module == null) {
            return null;
        }
        return module.getMember("exports");
    }

    private JSObject getModuleFromJson(JSObject parent, String filename, String moduleContentString) {
        JSObject module = this.newModule(parent, filename);
        module.setMember("exports", this.scriptEngineAndCompilationCache.jsonParse(this.scriptContext, moduleContentString));
        this.moduleCache.setMember(filename, (Object)module);
        module.setMember("loaded", (Object)Boolean.TRUE);
        return module;
    }

    private JSObject getModuleFromCompiledScript(JSObject parent, String filename, CompiledScript compiledScript) {
        try {
            JSObject module = this.newModule(parent, filename);
            this.moduleCache.setMember(filename, (Object)module);
            try {
                JSObject moduleWrapper = (JSObject)compiledScript.eval(this.scriptContext);
                moduleWrapper.call(module.getMember("exports"), new Object[]{module.getMember("exports"), module.getMember("require"), module, filename, ModuleSystem.dirname(filename)});
            }
            catch (RuntimeException | ScriptException e) {
                this.moduleCache.removeMember(filename);
                throw e;
            }
            module.setMember("loaded", (Object)Boolean.TRUE);
            return module;
        }
        catch (ScriptException e) {
            Throwable cause = e.getCause();
            if (cause instanceof NashornException) {
                throw (NashornException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(e);
        }
    }

    private JSObject newModule(JSObject parent, String filename) {
        return this.scriptEngineAndCompilationCache.newModule(this.scriptContext, parent, filename, (thisModule, newId) -> this.requireModule(thisModule, newId), (thisModule, newId) -> this.resolve(thisModule, newId));
    }

    public Object require(JSObject parent, String id) {
        JSObject module = this.requireModule(parent, id);
        if (module == null) {
            return null;
        }
        return module.getMember("exports");
    }

    public JSObject requireModule(JSObject parent, String id) {
        String parentFilename = parent == null ? "/." : (String)parent.getMember("filename");
        String cachedResolution = this.scriptEngineAndCompilationCache.getCachedModuleResolution(parentFilename, id);
        if (cachedResolution != null) {
            return this.requireModuleFile(parent, cachedResolution);
        }
        JSObject module = this.requireModuleUncached(parent, parentFilename, id);
        if (module == null) {
            return null;
        }
        String filename = (String)module.getMember("filename");
        this.scriptEngineAndCompilationCache.cacheModuleResolution(parentFilename, id, filename);
        return module;
    }

    private JSObject requireModuleUncached(JSObject parent, String parentFilename, String id) {
        JSObject resolvedCoreModule = this.requireModuleFile(parent, id);
        if (resolvedCoreModule != null) {
            return resolvedCoreModule;
        }
        try {
            Path parentFilepath = Paths.get(parentFilename, new String[0]);
            if (id.startsWith("./") || id.startsWith("../") || id.startsWith("/")) {
                String absoluteId = parentFilepath.resolveSibling(id).normalize().toString();
                JSObject resolvedModule = this.requireModuleFile(parent, absoluteId);
                if (resolvedModule != null) {
                    return resolvedModule;
                }
                resolvedModule = this.requireModuleDirectory(parent, absoluteId);
                if (resolvedModule != null) {
                    return resolvedModule;
                }
            } else {
                while ((parentFilepath = parentFilepath.getParent()) != null) {
                    if (parentFilepath.getFileName() != null && parentFilepath.getFileName().toString().equals("node_modules")) continue;
                    String absoluteId = parentFilepath.resolve("node_modules").resolve(id).normalize().toString();
                    JSObject resolvedModule = this.requireModuleFile(parent, absoluteId);
                    if (resolvedModule != null) {
                        return resolvedModule;
                    }
                    resolvedModule = this.requireModuleDirectory(parent, absoluteId);
                    if (resolvedModule == null) continue;
                    return resolvedModule;
                }
            }
            return null;
        }
        catch (NashornException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.scriptEngineAndCompilationCache.reasonToException(this.scriptContext, e);
        }
    }

    private JSObject requireModuleFile(JSObject parent, String absoluteId) {
        JSObject module = this.getModule(parent, absoluteId);
        if (module != null) {
            return module;
        }
        module = this.getModule(parent, absoluteId + ".js");
        if (module != null) {
            return module;
        }
        module = this.getModule(parent, absoluteId + ".json");
        if (module != null) {
            return module;
        }
        return null;
    }

    private JSObject requireModuleDirectory(JSObject parent, String absoluteId) {
        String main = this.getMainFromPackageJson(parent, absoluteId);
        if (main != null) {
            JSObject resolvedModule = this.requireModuleFile(parent, Paths.get(absoluteId, new String[0]).resolve(main).normalize().toString());
            if (resolvedModule != null) {
                return resolvedModule;
            }
        } else {
            JSObject module = this.getModule(parent, absoluteId + "/index.js");
            if (module != null) {
                return module;
            }
            module = this.getModule(parent, absoluteId + "/index.json");
            if (module != null) {
                return module;
            }
        }
        return null;
    }
}

