/*
 * Decompiled with CFR 0.152.
 */
package net.cnri.util.javascript.nashorn;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import jdk.nashorn.api.scripting.JSObject;

public class JavaScriptEventLoop {
    static final ThreadLocal<JavaScriptEventLoop> threadLocalJavaScriptEventLoop = new ThreadLocal();
    private static final AtomicInteger threadNumber = new AtomicInteger(1);
    private final ScheduledExecutorService execServ = Executors.newScheduledThreadPool(1, r -> new Thread(r, "JavaScript-event-loop-" + threadNumber.getAndIncrement()));

    public JavaScriptEventLoop() {
        ((ScheduledThreadPoolExecutor)this.execServ).setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        ((ScheduledThreadPoolExecutor)this.execServ).setRemoveOnCancelPolicy(true);
        try {
            this.execServ.submit(() -> threadLocalJavaScriptEventLoop.set(this)).get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public Future<?> submit(Runnable r) {
        return this.execServ.submit(r);
    }

    public <T> Future<T> submit(Callable<T> c) {
        return this.execServ.submit(c);
    }

    public void clear() throws InterruptedException {
        BlockingQueue<Runnable> queue = ((ThreadPoolExecutor)((Object)this.execServ)).getQueue();
        try {
            this.execServ.submit(() -> queue.clear()).get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new RuntimeException(e);
        }
    }

    public void shutdown() {
        this.execServ.shutdown();
    }

    public Future<?> setImmediate(Object ueh, JSObject fn, Object ... args) {
        return this.execServ.submit(this.handleExceptions(ueh, () -> fn.call(null, args)));
    }

    public Future<?> setTimeout(Object ueh, JSObject fn, long delay, Object ... args) {
        return this.execServ.schedule(this.handleExceptions(ueh, () -> fn.call(null, args)), delay, TimeUnit.MILLISECONDS);
    }

    public Future<?> setInterval(Object ueh, JSObject fn, long delay, Object ... args) {
        return this.execServ.scheduleWithFixedDelay(this.handleExceptions(ueh, () -> fn.call(null, args)), delay, delay, TimeUnit.MILLISECONDS);
    }

    private Runnable handleExceptions(Object ueh, Runnable runnable) {
        return () -> {
            try {
                runnable.run();
            }
            catch (Throwable t) {
                if (ueh instanceof Thread.UncaughtExceptionHandler) {
                    ((Thread.UncaughtExceptionHandler)ueh).uncaughtException(Thread.currentThread(), t);
                } else if (ueh instanceof JSObject) {
                    ((JSObject)ueh).call(null, new Object[]{Thread.currentThread(), t});
                } else {
                    t.printStackTrace();
                }
                throw t;
            }
        };
    }
}

