/*
 * Decompiled with CFR 0.152.
 */
package net.cnri.util.javascript.nashorn;

import java.util.concurrent.atomic.AtomicLong;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.SimpleScriptContext;
import jdk.nashorn.api.scripting.JSObject;
import net.cnri.util.javascript.nashorn.BoundedObjectPool;
import net.cnri.util.javascript.nashorn.JavaScriptEventLoop;
import net.cnri.util.javascript.nashorn.JavaScriptRunner;
import net.cnri.util.javascript.nashorn.RequireLookup;
import net.cnri.util.javascript.nashorn.ScriptEngineAndCompilationCache;

public class JavaScriptEnvironment {
    private final RequireLookup requireLookup;
    private final ScriptEngineAndCompilationCache scriptEngineAndCompilationCache;
    private final BoundedObjectPool<JavaScriptEventLoop> eventLoopPool;
    private final BoundedObjectPool<ScriptContext> globalPool;
    private final AtomicLong generation = new AtomicLong(1L);

    public JavaScriptEnvironment(RequireLookup requireLookup) {
        this(requireLookup, JavaScriptEnvironment.class.getClassLoader());
    }

    public JavaScriptEnvironment(RequireLookup requireLookup, ClassLoader classLoader) {
        this.requireLookup = requireLookup;
        this.setNashornArgs();
        ScriptEngineManager manager = new ScriptEngineManager();
        ClassLoader contextClassLoader = null;
        if (classLoader != null) {
            contextClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        ScriptEngine scriptEngine = manager.getEngineByName("nashorn");
        if (classLoader != null) {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
        this.scriptEngineAndCompilationCache = new ScriptEngineAndCompilationCache(scriptEngine);
        this.eventLoopPool = new BoundedObjectPool<JavaScriptEventLoop>(){

            @Override
            protected JavaScriptEventLoop create() {
                return new JavaScriptEventLoop();
            }

            @Override
            protected boolean reset(JavaScriptEventLoop obj) {
                try {
                    obj.clear();
                    return true;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return false;
                }
            }

            @Override
            protected void destroy(JavaScriptEventLoop obj) {
                obj.shutdown();
            }
        };
        this.globalPool = new BoundedObjectPool<ScriptContext>(){

            @Override
            protected ScriptContext create() {
                SimpleScriptContext scriptContext = new SimpleScriptContext();
                scriptContext.setBindings(JavaScriptEnvironment.this.scriptEngineAndCompilationCache.getScriptEngine().createBindings(), 100);
                JavaScriptEnvironment.this.scriptEngineAndCompilationCache.initializeScriptContext(scriptContext);
                JSObject cnriJse = (JSObject)((JSObject)scriptContext.getAttribute("cnri")).getMember("_jse");
                cnriJse.setMember("generation", (Object)JavaScriptEnvironment.this.generation.get());
                return scriptContext;
            }

            @Override
            protected boolean reset(ScriptContext obj) {
                JSObject cnriJse = (JSObject)((JSObject)obj.getAttribute("cnri")).getMember("_jse");
                long objGeneration = ((Number)cnriJse.getMember("generation")).longValue();
                return objGeneration >= JavaScriptEnvironment.this.generation.get();
            }

            @Override
            protected void destroy(ScriptContext obj) {
            }
        };
    }

    private void setNashornArgs() {
        if (System.getProperty("nashorn.args") != null) {
            return;
        }
        String version = System.getProperty("java.version");
        if (!version.startsWith("1.") && !version.startsWith("10") && version.startsWith("1") && System.getProperty("nashorn.args") == null) {
            System.setProperty("nashorn.args", "--language=es6 --no-deprecation-warning");
        } else {
            System.setProperty("nashorn.args", "--language=es6");
        }
    }

    public ScriptEngineAndCompilationCache getScriptEngineAndCompilationCache() {
        return this.scriptEngineAndCompilationCache;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.globalPool.setMaxPoolSize(maxPoolSize);
        this.eventLoopPool.setMaxPoolSize(maxPoolSize);
    }

    public void clearCache() {
        this.scriptEngineAndCompilationCache.clearCache();
        this.generation.incrementAndGet();
        this.globalPool.clear();
    }

    public JavaScriptRunner getRunner(Thread.UncaughtExceptionHandler uncaughtExceptionHandler, Object logger) {
        ScriptContext scriptContext = this.globalPool.obtain();
        JavaScriptEventLoop eventLoop = this.eventLoopPool.obtain();
        return new JavaScriptRunner(this.scriptEngineAndCompilationCache, scriptContext, eventLoop, this.requireLookup, uncaughtExceptionHandler, logger);
    }

    public void recycle(JavaScriptRunner runner) {
        this.globalPool.recycle(runner.getScriptContext());
        this.eventLoopPool.recycle(runner.getEventLoop());
    }

    public void recycleDiscardingScriptContext(JavaScriptRunner runner) {
        this.eventLoopPool.recycle(runner.getEventLoop());
    }

    public void warmUp() {
        this.recycle(this.getRunner(null, null));
    }

    public void shutdown() {
        this.setMaxPoolSize(0);
        this.eventLoopPool.clear();
    }
}

