/*
 * Decompiled with CFR 0.152.
 */
package net.cnri.util.javascript.nashorn;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class BoundedObjectPool<T> {
    private ConcurrentLinkedQueue<T> pool = new ConcurrentLinkedQueue();
    private AtomicInteger poolSize = new AtomicInteger();
    private int maxPoolSize = 100;

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    protected abstract T create();

    protected abstract boolean reset(T var1);

    protected abstract void destroy(T var1);

    public void clear() {
        T obj;
        while ((obj = this.pool.poll()) != null) {
            this.poolSize.decrementAndGet();
            this.destroy(obj);
        }
    }

    public T obtain() {
        T res = this.pool.poll();
        if (res != null) {
            this.poolSize.decrementAndGet();
            return res;
        }
        return this.create();
    }

    public void recycle(T obj) {
        if (this.poolSize.incrementAndGet() < this.maxPoolSize && this.reset(obj)) {
            this.pool.offer(obj);
        } else {
            this.poolSize.decrementAndGet();
            this.destroy(obj);
        }
    }
}

