/*
 * Decompiled with CFR 0.152.
 */
package net.clockworkcode.yamlrecord;

import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.clockworkcode.yamlrecord.Data;
import net.clockworkcode.yamlrecord.Record;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class RecordConverter {
    public static String toYaml(Record record) {
        Map<String, Object> properties = RecordConverter.toMapRepresentation(record);
        return RecordConverter.toYamlString(properties);
    }

    public static Record toRecord(String yaml) {
        Map loadedMapRepresentation = (Map)new Yaml().load(yaml);
        ZonedDateTime recordDate = ZonedDateTime.parse((String)loadedMapRepresentation.get("Date"));
        String recordType = (String)loadedMapRepresentation.get("Type");
        Record record = new Record(recordType, recordDate);
        record.setDataList(RecordConverter.toDataList(loadedMapRepresentation));
        return record;
    }

    private static List<Data> toDataList(Map loadedMapRepresentation) {
        List dataListMaps = (List)loadedMapRepresentation.get("Data");
        return dataListMaps.stream().map(RecordConverter::toDataItem).filter(i -> !i.getLabel().equals("")).collect(Collectors.toList());
    }

    private static Map<String, Object> toMapRepresentation(Record record) {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        properties.put("Type", record.getType());
        properties.put("Date", DateTimeFormatter.ISO_INSTANT.format(record.getDateTime()));
        properties.put("System", DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(record.getDateTime()));
        List collect = record.getDataList().stream().map(RecordConverter::toDataMap).collect(Collectors.toList());
        properties.put("Data", collect);
        return properties;
    }

    private static String toYamlString(Map<String, Object> properties) {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setExplicitStart(true);
        Yaml yaml = new Yaml(options);
        return yaml.dump(properties);
    }

    private static Map<String, Object> toDataMap(Data data) {
        LinkedHashMap<String, Object> dataMap = new LinkedHashMap<String, Object>();
        dataMap.put("Label", data.getLabel());
        dataMap.put("Value", data.getValue());
        dataMap.put("Unit", data.getUnit());
        return dataMap;
    }

    private static Data toDataItem(Map<String, Object> items) {
        Data data = null;
        try {
            data = new Data((String)items.get("Label"), BigDecimal.valueOf((Double)items.get("Value")), (String)items.get("Unit"));
        }
        catch (Exception e) {
            return Data.NULL_DATA;
        }
        return data;
    }
}

