/*
 * Decompiled with CFR 0.152.
 */
package net.clockworkcode.yamlrecord;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import net.clockworkcode.yamlrecord.Data;

public class Record {
    ZonedDateTime dateTime;
    String system;
    String type;
    List<Data> dataList = new ArrayList<Data>();

    public Record(String type, ZonedDateTime dateTime) {
        this.type = type;
        this.dateTime = dateTime;
        ZonedDateTime dateTimeSystem = ZonedDateTime.ofInstant(dateTime.toInstant(), ZoneId.systemDefault());
        this.system = DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(dateTimeSystem);
    }

    public ZonedDateTime getDateTime() {
        return this.dateTime;
    }

    public String getSystem() {
        return this.system;
    }

    public String getType() {
        return this.type;
    }

    public List<Data> getDataList() {
        return this.dataList;
    }

    public void setDataList(List<Data> dataList) {
        this.dataList = dataList;
    }

    public void add(Data data) {
        this.dataList.add(data);
    }
}

