/*
 * Decompiled with CFR 0.152.
 */
package net.clockworkcode.math.calc;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import net.clockworkcode.math.calc.FunctionDetails;
import net.clockworkcode.math.calc.FunctionNameToken;
import net.clockworkcode.math.calc.Functions;
import net.clockworkcode.math.calc.NumericToken;
import net.clockworkcode.math.calc.Operator;
import net.clockworkcode.math.calc.OperatorToken;
import net.clockworkcode.math.calc.Token;
import net.clockworkcode.math.calc.Variable;
import net.clockworkcode.math.calc.Variables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpnCalculator {
    private static Logger LOG = LoggerFactory.getLogger(RpnCalculator.class);
    private Functions functions = new Functions();
    private Variables variables = new Variables();
    private Stack<BigDecimal> resultStack = new Stack();
    private Token currentToken;

    public BigDecimal calculate(List<Token> tokens) {
        this.resultStack = new Stack();
        LOG.info("Calculating {}", (Object)Token.joinValues(tokens, " "));
        LOG.debug("| Token | Action | Stack | Notes |");
        Iterator<Token> iterator = tokens.iterator();
        while (iterator.hasNext()) {
            Token token;
            this.currentToken = token = iterator.next();
            switch (this.currentToken.getType()) {
                case NUMBER: {
                    this.resultStack.push(((NumericToken)this.currentToken).getNumber());
                    RpnCalculator.log(this.currentToken, "Push value", this.resultStack, "");
                    break;
                }
                case VARIABLE: {
                    this.resultStack.push(this.variables.getValue(token.getValue()));
                    RpnCalculator.log(this.currentToken, "Push value", this.resultStack, "");
                    break;
                }
                case OPERATOR: {
                    Operator op = ((OperatorToken)this.currentToken).getOperator();
                    this.execute(op.getArguments(), op.getCalc());
                    break;
                }
                case FUNCTION: {
                    FunctionNameToken funtionToken = (FunctionNameToken)this.currentToken;
                    this.execute(funtionToken.getArity(), this.functions.get(funtionToken.getValue()));
                }
            }
        }
        if (this.resultStack.size() > 1) {
            throw new RuntimeException("Too many values after calculation, stack " + this.resultStack);
        }
        return this.resultStack.pop();
    }

    private void execute(int arity, FunctionDetails function) {
        List<BigDecimal> args = this.popRequiredArgs(arity, function);
        RpnCalculator.log(this.currentToken, "Pop Function Args", this.resultStack, args);
        BigDecimal result = function.execute(args);
        this.resultStack.push(result);
        RpnCalculator.log(this.currentToken, "Push value", this.resultStack, result);
    }

    private List<BigDecimal> popRequiredArgs(int arity, FunctionDetails function) {
        if (function.isVariadic() && arity > this.resultStack.size()) {
            throw new RuntimeException("not enough operands for the calculation, op " + function.getName() + " stack " + this.resultStack);
        }
        ArrayList<BigDecimal> funcArgs = new ArrayList<BigDecimal>();
        for (int i = 0; i < arity; ++i) {
            funcArgs.add(this.resultStack.pop());
        }
        Collections.reverse(funcArgs);
        return funcArgs;
    }

    public void add(FunctionDetails function) {
        this.functions.add(function);
    }

    public void add(Variable variable) {
        this.variables.add(variable);
    }

    public Set<String> getFunctionNames() {
        return this.functions.getFunctionNames();
    }

    public Set<String> getVariableNames() {
        return this.variables.getVariableNames();
    }

    private static void log(Token token, String action, Stack<BigDecimal> stack, List<BigDecimal> operands) {
        String operandsJoined = operands.stream().map(BigDecimal::toString).collect(Collectors.joining(", "));
        RpnCalculator.log(token, action, stack, String.format("Args: %1$s", operandsJoined));
    }

    private static void log(Token token, String action, Stack<BigDecimal> stack, BigDecimal result) {
        RpnCalculator.log(token, action, stack, String.format("Result: %1$f", result));
    }

    private static void log(Token token, String action, Stack<BigDecimal> stack, String notes) {
        String stackValues = stack.stream().map(BigDecimal::toString).collect(Collectors.joining(" "));
        LOG.debug("| {} | {} | {} | {} |", new Object[]{token.getValue(), action, stackValues, notes});
    }
}

