/*
 * Decompiled with CFR 0.152.
 */
package net.clockworkcode.math.calc;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import net.clockworkcode.math.calc.FunctionNameToken;
import net.clockworkcode.math.calc.NumericToken;
import net.clockworkcode.math.calc.Operator;
import net.clockworkcode.math.calc.OperatorToken;
import net.clockworkcode.math.calc.Token;
import net.clockworkcode.math.calc.Type;

public class InfixTokeniser
implements Iterator<Token> {
    private Set<String> functionNames;
    private Set<String> variableNames;
    private List<String> input;
    private Stack<Type> parenStack = new Stack();
    private Token previousToken;
    private int index = 0;

    public InfixTokeniser(String input, Set<String> functionNames, Set<String> variableNames) {
        this.input = InfixTokeniser.split(input);
        this.functionNames = functionNames;
        this.variableNames = variableNames;
    }

    public InfixTokeniser(String input) {
        this.input = InfixTokeniser.split(input);
        this.functionNames = Collections.EMPTY_SET;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.input.size();
    }

    @Override
    public Token next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more elements, index: " + this.index);
        }
        String currentValue = this.input.get(this.index);
        Token token = this.createToken(currentValue);
        ++this.index;
        this.previousToken = token;
        return token;
    }

    private Token createToken(String currentValue) {
        Optional<? extends Token> token = this.maybeParen(currentValue);
        if (!token.isPresent()) {
            token = this.maybeComma(currentValue);
        }
        if (!token.isPresent()) {
            token = this.maybeFunction(currentValue);
        }
        if (!token.isPresent()) {
            token = this.maybeVariable(currentValue);
        }
        if (!token.isPresent()) {
            token = this.maybeDashOperator(currentValue);
        }
        if (!token.isPresent()) {
            token = this.maybeOperator(currentValue);
        }
        if (!token.isPresent()) {
            token = this.maybeNumeric(currentValue);
        }
        if (!token.isPresent()) {
            throw new RuntimeException(String.format("Could not determine token type for %1$s at index %2$d", currentValue, this.index));
        }
        return token.get();
    }

    private Optional<? extends Token> maybeParen(String currentValue) {
        Type type = Type.NONE;
        if (currentValue.equals("(")) {
            type = this.previousTokenisFunction() ? Type.FUNCTION_LEFT_PAREN : Type.LEFT_PAREN;
            this.parenStack.push(type);
        } else if (currentValue.equals(")")) {
            Type openingParamWas = this.parenStack.pop();
            type = openingParamWas == Type.FUNCTION_LEFT_PAREN ? Type.FUNCTION_RIGHT_PAREN : Type.RIGHT_PAREN;
        }
        return type == Type.NONE ? Optional.empty() : Optional.of(new Token(currentValue, type));
    }

    private boolean previousTokenisFunction() {
        return this.previousToken != null && this.previousToken.getType() == Type.FUNCTION;
    }

    private Optional<NumericToken> maybeNumeric(String currentValue) {
        BigDecimal number = null;
        if (Character.isDigit(currentValue.charAt(0))) {
            try {
                number = new BigDecimal(currentValue);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not convert numeric value " + currentValue);
            }
        }
        return number == null ? Optional.empty() : Optional.of(new NumericToken(currentValue, Type.NUMBER, number));
    }

    private Optional<Token> maybeFunction(String currentValue) {
        return this.functionNames.contains(currentValue) ? Optional.of(new FunctionNameToken(currentValue, Type.FUNCTION)) : Optional.empty();
    }

    private Optional<Token> maybeVariable(String currentValue) {
        return this.variableNames.contains(currentValue) ? Optional.of(new FunctionNameToken(currentValue, Type.VARIABLE)) : Optional.empty();
    }

    private Optional<Token> maybeComma(String currentValue) {
        return currentValue.equals(",") ? Optional.of(new Token(",", Type.COMMA)) : Optional.empty();
    }

    private Optional<OperatorToken> maybeDashOperator(String currentValue) {
        if (currentValue.equals("-")) {
            Operator operator = Operator.UNARY_MINUS;
            if (this.previousToken != null && (this.previousToken.getType() == Type.FUNCTION_RIGHT_PAREN || this.previousToken.getType() == Type.RIGHT_PAREN || this.previousToken.getType() == Type.VARIABLE || this.previousToken.getType() == Type.NUMBER)) {
                operator = Operator.MINUS;
            }
            return Optional.of(new OperatorToken(currentValue, Type.OPERATOR, operator));
        }
        return Optional.empty();
    }

    private Optional<OperatorToken> maybeOperator(String currentValue) {
        Optional<Operator> operator = Operator.valueOfSymbol(currentValue);
        if (operator.isPresent()) {
            return Optional.of(new OperatorToken(currentValue, Type.OPERATOR, operator.get()));
        }
        return Optional.empty();
    }

    private static List<String> split(String input) {
        return Arrays.stream(input.split("(?<=[^\\.a-zA-Z\\d])|(?=[^\\.a-zA-Z\\d])")).map(String::trim).filter(t -> t.length() > 0).collect(Collectors.toList());
    }
}

