/*
 * Decompiled with CFR 0.152.
 */
package net.clockworkcode.math.calc;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Stack;
import net.clockworkcode.math.calc.FunctionNameToken;
import net.clockworkcode.math.calc.Token;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfixToRpnState {
    private static Logger LOG = LoggerFactory.getLogger(InfixToRpnState.class);
    private List<Token> result = new ArrayList<Token>();
    private Stack<Token> opStack = new Stack();
    private Stack<Integer> functionParamCount = new Stack();
    private Token currentToken = null;

    public void newFunction() {
        this.functionParamCount.push(1);
    }

    public void addFunctionParam() {
        Integer currentCount = this.functionParamCount.pop();
        this.functionParamCount.push(currentCount + 1);
    }

    public int getFunctionParamCount() {
        return this.functionParamCount.pop();
    }

    public List<Token> getResult() {
        return this.result;
    }

    public Token getCurrentToken() {
        return this.currentToken;
    }

    public void setCurrentToken(Token currentToken) {
        this.currentToken = currentToken;
    }

    public Optional<Token> peekStack() {
        return this.opStack.isEmpty() ? Optional.empty() : Optional.of(this.opStack.peek());
    }

    public boolean stackIsEmpty() {
        return this.opStack.isEmpty();
    }

    public Token popStack() {
        Token pop = this.opStack.pop();
        this.log("Pop stack", "");
        return pop;
    }

    public Token popStackToResult() {
        Token pop = this.opStack.pop();
        this.result.add(pop);
        String notes = pop instanceof FunctionNameToken ? "Parameter count: " + ((FunctionNameToken)pop).arity : "";
        this.log("Pop to output " + pop.getValue(), notes);
        return pop;
    }

    public void addCurrentTokenToResult() {
        this.result.add(this.currentToken);
        this.log("Add to output", "");
    }

    public void addCurrentTokenToStack() {
        this.opStack.add(this.currentToken);
        this.log("Add to stack", "");
    }

    private void log(String action, String notes) {
        LOG.debug("| {} | {} | {} | {} | {} |", new Object[]{this.currentToken == null ? "end" : this.currentToken.getValue(), action, Token.joinValues(this.result, " "), Token.joinValues(this.opStack, ""), notes});
    }
}

