/*
 * Decompiled with CFR 0.152.
 */
package net.clockworkcode.math.calc;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.clockworkcode.math.calc.FunctionNameToken;
import net.clockworkcode.math.calc.InfixToRpnState;
import net.clockworkcode.math.calc.InfixTokeniser;
import net.clockworkcode.math.calc.OperatorToken;
import net.clockworkcode.math.calc.Token;
import net.clockworkcode.math.calc.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfixToRpn {
    private Set<String> functionNames;
    private Set<String> variableNames;
    private static Logger LOG = LoggerFactory.getLogger(InfixToRpn.class);
    private InfixToRpnState state = new InfixToRpnState();

    public InfixToRpn() {
        this.functionNames = Collections.emptySet();
        this.variableNames = Collections.emptySet();
    }

    public InfixToRpn(Set<String> functionNames, Set<String> variableNames) {
        this.functionNames = functionNames;
        this.variableNames = variableNames;
    }

    public List<Token> convert(String input) {
        LOG.info("converting " + input);
        LOG.debug("| Token | Action | Output | Stack | Notes |");
        InfixTokeniser tokeniser = new InfixTokeniser("(" + input + ")", this.functionNames, this.variableNames);
        block9: while (tokeniser.hasNext()) {
            this.state.setCurrentToken(tokeniser.next());
            switch (this.state.getCurrentToken().getType()) {
                case NUMBER: 
                case VARIABLE: {
                    this.state.addCurrentTokenToResult();
                    continue block9;
                }
                case OPERATOR: {
                    this.handleOperator();
                    continue block9;
                }
                case LEFT_PAREN: 
                case FUNCTION_LEFT_PAREN: {
                    this.state.addCurrentTokenToStack();
                    continue block9;
                }
                case FUNCTION: {
                    this.handleFunction();
                    continue block9;
                }
                case RIGHT_PAREN: {
                    this.handleRightParen();
                    continue block9;
                }
                case COMMA: {
                    this.handleComma();
                    continue block9;
                }
                case FUNCTION_RIGHT_PAREN: {
                    this.handleFunctionRightParen();
                    continue block9;
                }
            }
            throw new RuntimeException("Unknown token " + this.state.getCurrentToken().getValue());
        }
        return this.state.getResult();
    }

    private void handleFunction() {
        this.state.addCurrentTokenToStack();
        this.state.newFunction();
    }

    private void handleComma() {
        this.popToResultUntilLeftParenFound(Type.FUNCTION_LEFT_PAREN);
        this.state.addFunctionParam();
    }

    private void handleFunctionRightParen() {
        this.popToResultUntilLeftParenFound(Type.FUNCTION_LEFT_PAREN);
        this.state.popStack();
        this.setFunctionArity();
        this.state.popStackToResult();
    }

    private void setFunctionArity() {
        FunctionNameToken token = (FunctionNameToken)this.state.peekStack().get();
        token.setArity(this.state.getFunctionParamCount());
    }

    private void handleRightParen() {
        this.popToResultUntilLeftParenFound(Type.LEFT_PAREN);
        this.state.popStack();
    }

    private void popToResultUntilLeftParenFound(Type parenType) {
        Optional<Token> op = null;
        while ((op = this.state.peekStack()).isPresent() && op.get().getType() != parenType) {
            this.state.popStackToResult();
        }
    }

    private void handleOperator() {
        if (this.state.stackIsEmpty()) {
            this.state.addCurrentTokenToResult();
        } else {
            OperatorToken tokenOp = (OperatorToken)this.state.getCurrentToken();
            Optional<Token> tokenStack = null;
            while ((tokenStack = this.state.peekStack()).isPresent() && tokenStack.get() instanceof OperatorToken && tokenOp.lowerPreferenceThan((OperatorToken)tokenStack.get())) {
                this.state.popStackToResult();
            }
            this.state.addCurrentTokenToStack();
        }
    }
}

