/*
 * Decompiled with CFR 0.152.
 */
package net.clockworkcode.math.calc;

import java.math.BigDecimal;
import java.util.List;
import java.util.function.Function;

public class FunctionDetails {
    private String name;
    private Function<List<BigDecimal>, BigDecimal> function;
    private Integer arity;
    private boolean variadic;

    public boolean isVariadic() {
        return this.variadic;
    }

    public Integer getArity() {
        return this.arity;
    }

    public String getName() {
        return this.name;
    }

    public FunctionDetails(String name, Function<List<BigDecimal>, BigDecimal> function, Integer arity) {
        this.name = name;
        this.function = function;
        this.arity = arity;
        this.variadic = false;
    }

    public FunctionDetails(String name, Function<List<BigDecimal>, BigDecimal> function) {
        this.name = name;
        this.function = function;
        this.variadic = true;
    }

    public BigDecimal execute(List<BigDecimal> args) {
        if (!this.variadic && args.size() != this.arity.intValue()) {
            throw new RuntimeException("Number of arguments passed does not match the arity of " + this.name + " arity: " + this.arity);
        }
        return this.function.apply(args);
    }
}

