/*
 * Decompiled with CFR 0.152.
 */
package net.chibidevteam.apiversioning.util.helper;

import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import net.chibidevteam.apiversioning.config.ApiVersioningConfiguration;
import net.chibidevteam.apiversioning.pojo.Version;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.CollectionUtils;

public final class VersionHelper {
    private static final Log LOGGER = LogFactory.getLog(VersionHelper.class);

    private VersionHelper() {
    }

    public static boolean match(String toTest, String[] versions, boolean isTestFromPath) {
        boolean result = false;
        for (String v : versions) {
            boolean matched = VersionHelper.match(toTest, v, isTestFromPath);
            if (VersionHelper.isExcludeVersion(v) && !matched) {
                return false;
            }
            result |= matched;
        }
        return result;
    }

    public static boolean match(String toTest, String version, boolean isTestFromPath) {
        boolean isWrongPathVersion = isTestFromPath && !toTest.matches(ApiVersioningConfiguration.getPathVersionRegex());
        LOGGER.trace((Object)("isTestFromPath: " + isTestFromPath));
        LOGGER.trace((Object)("isWrongPathVersion: " + isWrongPathVersion));
        LOGGER.trace((Object)("isVersion('" + toTest + "'): " + VersionHelper.isVersion(toTest)));
        LOGGER.trace((Object)("isVersion('" + version + "'): " + VersionHelper.isVersion(version)));
        if (isWrongPathVersion || !VersionHelper.isVersion(toTest) || !VersionHelper.isVersion(version)) {
            return false;
        }
        if (VersionHelper.isCompatibilityVersion(version)) {
            return VersionHelper.isCompatible(toTest, version);
        }
        if (VersionHelper.isSuperiorityVersion(version)) {
            return VersionHelper.isSuperior(toTest, version);
        }
        if (VersionHelper.isInferiorityVersion(version)) {
            return VersionHelper.isInferior(toTest, version);
        }
        if (VersionHelper.isExcludeVersion(version)) {
            return VersionHelper.isNot(toTest, version);
        }
        if (VersionHelper.isExactlyVersion(version)) {
            return VersionHelper.isExact(toTest, version);
        }
        return false;
    }

    public static boolean isVersion(String toTest) {
        LOGGER.trace((Object)("Testing '" + toTest + "' with '" + ApiVersioningConfiguration.getConfVersionRegex() + "' and '" + ApiVersioningConfiguration.getPathVersionRegex() + "'"));
        return toTest.matches(ApiVersioningConfiguration.getConfVersionRegex()) || toTest.matches(ApiVersioningConfiguration.getPathVersionRegex());
    }

    public static SortedSet<String> getRealVersions(SortedSet<String> versions, SortedSet<String> supportedVersions) {
        if (CollectionUtils.isEmpty(supportedVersions)) {
            LOGGER.trace((Object)"No supported version");
            return new TreeSet<String>();
        }
        if (CollectionUtils.isEmpty(versions)) {
            LOGGER.trace((Object)"Support all versions");
            return supportedVersions;
        }
        TreeSet<String> result = new TreeSet<String>();
        for (String sv : supportedVersions) {
            boolean matchExact;
            boolean matchAllButCompatibilityOrExact = true;
            boolean hasCompatibility = false;
            boolean matchAtLeastOneCompatibility = false;
            boolean hasExact = false;
            boolean matchAtLeastOneExact = false;
            for (String v : versions) {
                boolean match = VersionHelper.match(sv, v, false);
                LOGGER.trace((Object)("Testing '" + sv + "' over '" + v + "' => " + (match ? "does match" : "does NOT match")));
                if (VersionHelper.isCompatibilityVersion(v)) {
                    hasCompatibility = true;
                    matchAtLeastOneCompatibility |= match;
                    continue;
                }
                if (VersionHelper.isExactlyVersion(v)) {
                    hasExact = true;
                    matchAtLeastOneExact |= match;
                    continue;
                }
                matchAllButCompatibilityOrExact &= match;
            }
            boolean matchCompatibility = !hasCompatibility || hasCompatibility && matchAtLeastOneCompatibility;
            boolean bl = matchExact = !hasExact || hasExact && matchAtLeastOneExact;
            if (!matchAllButCompatibilityOrExact || !matchCompatibility || !matchExact) continue;
            result.add(VersionHelper.simplify(sv));
        }
        return result;
    }

    private static String simplify(String version) {
        Version v = VersionHelper.fromString(version);
        Integer major = v.getMajor() == null ? 0 : v.getMajor();
        Integer minor = v.getMinor() == null ? 0 : v.getMinor();
        Integer patch = v.getPatch() == null ? 0 : v.getPatch();
        List<String> others = v.getOthers();
        StringBuilder sb = new StringBuilder();
        if (!others.isEmpty()) {
            sb.insert(0, StringUtils.join(v.getOthers(), (String)""));
        }
        if (sb.length() > 0 || patch != 0) {
            sb.insert(0, patch);
            sb.insert(0, '.');
        }
        if (sb.length() > 0 || minor != 0) {
            sb.insert(0, minor);
            sb.insert(0, '.');
        }
        sb.insert(0, major);
        return sb.toString();
    }

    private static boolean isCompatible(String toTest, String version) {
        Version versionV;
        Version toTestV = VersionHelper.fromString(toTest);
        boolean sameMajor = VersionHelper.compareMajor(toTestV, versionV = VersionHelper.fromString(version)) == 0;
        boolean higherMinor = VersionHelper.compareMinor(toTestV, versionV) >= 0;
        boolean higherPatch = VersionHelper.comparePatch(toTestV, versionV) >= 0;
        return sameMajor && higherMinor && higherPatch;
    }

    private static boolean isSuperior(String toTest, String version) {
        Version versionV;
        Version toTestV = VersionHelper.fromString(toTest);
        return toTestV.compareTo(versionV = VersionHelper.fromString(version)) >= 0;
    }

    private static boolean isInferior(String toTest, String version) {
        Version versionV;
        Version toTestV = VersionHelper.fromString(toTest);
        return toTestV.compareTo(versionV = VersionHelper.fromString(version)) < 0;
    }

    private static boolean isNot(String toTest, String version) {
        return !VersionHelper.isExact(toTest, version);
    }

    private static boolean isExact(String toTest, String version) {
        Version versionV;
        Version toTestV = VersionHelper.fromString(toTest);
        return toTestV.compareTo(versionV = VersionHelper.fromString(version)) == 0;
    }

    private static boolean isCompatibilityVersion(String version) {
        return version.matches(ApiVersioningConfiguration.getCompatibleVersionRegex());
    }

    private static boolean isSuperiorityVersion(String version) {
        return version.matches(ApiVersioningConfiguration.getSuperiorVersionRegex());
    }

    private static boolean isInferiorityVersion(String version) {
        return version.matches(ApiVersioningConfiguration.getInferiorVersionRegex());
    }

    private static boolean isExcludeVersion(String version) {
        return version.matches(ApiVersioningConfiguration.getExcludeVersionRegex());
    }

    private static boolean isExactlyVersion(String version) {
        return version.matches(ApiVersioningConfiguration.getExactVersionRegex());
    }

    private static int compareMajor(Version v1, Version v2) {
        return ApiVersioningConfiguration.INTEGER_COMPARATOR.compare(v1.getMajor(), v2.getMajor());
    }

    private static int compareMinor(Version v1, Version v2) {
        return ApiVersioningConfiguration.INTEGER_COMPARATOR.compare(v1.getMinor(), v2.getMinor());
    }

    private static int comparePatch(Version v1, Version v2) {
        return ApiVersioningConfiguration.INTEGER_COMPARATOR.compare(v1.getPatch(), v2.getPatch());
    }

    private static Version fromString(String str) {
        String newStr = str;
        if (newStr.startsWith(ApiVersioningConfiguration.getVersionPathPrefix())) {
            newStr = newStr.replaceFirst(ApiVersioningConfiguration.getVersionPathPrefix(), "");
        }
        Matcher m = ApiVersioningConfiguration.getVersionPattern().matcher(newStr);
        Version result = new Version();
        if (m.find()) {
            int grpCount = m.groupCount();
            for (int i = 1; i < grpCount; ++i) {
                result.setNext(m.group(i));
            }
        }
        return result;
    }
}

