/*
 * Decompiled with CFR 0.152.
 */
package net.chibidevteam.apiversioning.util.helper;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ClassHelper {
    private static final Log LOGGER = LogFactory.getLog(ClassHelper.class);

    private ClassHelper() {
    }

    public static <T> boolean areEquals(Class<T> clazz, T self, Object obj) {
        if (self == obj) {
            return true;
        }
        if (!clazz.isInstance(obj)) {
            return false;
        }
        T t = clazz.cast(obj);
        Map<String, Object> mapA = ClassHelper.getFields(clazz, self);
        Map<String, Object> mapB = ClassHelper.getFields(clazz, t);
        return Objects.equals(mapA, mapB);
    }

    public static <T> int hash(Class<T> clazz, T obj) {
        Map<String, Object> map = ClassHelper.getFields(clazz, obj);
        int h = 0;
        int i = 0;
        for (Object val : map.values()) {
            h += val == null ? 0 : val.hashCode() * 31 ^ ++i;
        }
        return h;
    }

    private static <T> Map<String, Object> getFields(Class<T> clazz, T obj) {
        Field[] fields;
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        for (Field field : fields = clazz.getDeclaredFields()) {
            field.setAccessible(true);
            try {
                map.put(field.getName(), field.get(obj));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                map.put(field.getName(), null);
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn((Object)("Cannot retrieve value of field '" + field.getName() + "' from class '" + clazz.getName() + "' of '" + obj + "'"), (Throwable)e);
            }
        }
        return map;
    }
}

