/*
 * Decompiled with CFR 0.152.
 */
package net.chibidevteam.apiversioning.util;

import net.chibidevteam.apiversioning.annotation.ApiRequestMapping;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

public class RequestMappingWrapper {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String[] paths;
    private RequestMethod[] methods;
    private String[] params;
    private String[] headers;
    private String[] consumes;
    private String[] produces;
    private String name;

    public RequestMappingWrapper(ApiRequestMapping apiRequestMapping) {
        if (apiRequestMapping != null) {
            this.paths = apiRequestMapping.path();
            this.methods = apiRequestMapping.method();
            this.params = apiRequestMapping.params();
            this.headers = apiRequestMapping.headers();
            this.consumes = apiRequestMapping.consumes();
            this.produces = apiRequestMapping.produces();
            this.name = apiRequestMapping.name();
        }
    }

    public RequestMappingWrapper(RequestMapping requestMapping) {
        if (requestMapping != null) {
            this.paths = requestMapping.path();
            this.methods = requestMapping.method();
            this.params = requestMapping.params();
            this.headers = requestMapping.headers();
            this.consumes = requestMapping.consumes();
            this.produces = requestMapping.produces();
            this.name = requestMapping.name();
        }
    }

    public String[] getPaths() {
        return this.paths;
    }

    public RequestMethod[] getMethods() {
        return this.methods;
    }

    public String[] getParams() {
        return this.params;
    }

    public String[] getHeaders() {
        return this.headers;
    }

    public String[] getConsumes() {
        return this.consumes;
    }

    public String[] getProduces() {
        return this.produces;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("{");
        if (ArrayUtils.isEmpty((Object[])this.paths)) {
            builder.append("NO_PATH");
        } else {
            builder.append(StringUtils.join((Object[])this.paths, (String)", "));
        }
        if (!ArrayUtils.isEmpty((Object[])this.methods)) {
            builder.append(",methods=").append(StringUtils.join((Object[])this.methods, (String)", "));
        }
        if (!ArrayUtils.isEmpty((Object[])this.params)) {
            builder.append(",params=").append(StringUtils.join((Object[])this.params, (String)", "));
        }
        if (!ArrayUtils.isEmpty((Object[])this.headers)) {
            builder.append(",headers=").append(StringUtils.join((Object[])this.headers, (String)", "));
        }
        if (!ArrayUtils.isEmpty((Object[])this.consumes)) {
            builder.append(",consumes=").append(StringUtils.join((Object[])this.consumes, (String)", "));
        }
        if (!ArrayUtils.isEmpty((Object[])this.produces)) {
            builder.append(",produces=").append(StringUtils.join((Object[])this.produces, (String)", "));
        }
        if (!StringUtils.isEmpty((CharSequence)this.name)) {
            builder.append(",name=").append(this.name);
        }
        builder.append('}');
        return builder.toString();
    }
}

