/*
 * Decompiled with CFR 0.152.
 */
package net.chibidevteam.apiversioning.mapping;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.stream.Stream;
import net.chibidevteam.apiversioning.annotation.ApiRequestMapping;
import net.chibidevteam.apiversioning.annotation.ApiVersion;
import net.chibidevteam.apiversioning.config.ApiVersioningConfiguration;
import net.chibidevteam.apiversioning.util.ApiVersionCondition;
import net.chibidevteam.apiversioning.util.RequestMappingWrapper;
import net.chibidevteam.apiversioning.util.helper.ApiPathHelper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.mvc.condition.HeadersRequestCondition;
import org.springframework.web.servlet.mvc.condition.ParamsRequestCondition;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.condition.RequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class ApiVersionRequestMappingHandlerMapping
extends RequestMappingHandlerMapping {
    protected RequestMappingInfo getMappingForMethod(Method method, Class<?> handlerType) {
        RequestMappingInfo info = this.createMappingForMethod(method, handlerType);
        if (info == null) {
            return null;
        }
        ApiVersionCondition apiVersionCondition = this.createApiVersionCondition(method, handlerType);
        boolean useApiPath = this.doUseApiPath(method, handlerType);
        return this.getRequestMappingInfo(apiVersionCondition, info, useApiPath);
    }

    private ApiVersionCondition createApiVersionCondition(Method method, Class<?> handlerType) {
        ApiVersionCondition methodApiVersionCondition = this.getApiVersionCondition(method);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)(handlerType.getName() + "::" + method.getName() + " accepts following versions: " + methodApiVersionCondition));
        }
        ApiVersionCondition handlerTypeApiVersionCondition = this.getApiVersionCondition(handlerType);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)(handlerType.getName() + " accepts following versions: " + handlerTypeApiVersionCondition));
        }
        ApiVersionCondition apiVersionCondition = methodApiVersionCondition != null && handlerTypeApiVersionCondition != null ? methodApiVersionCondition.restrictWith(handlerTypeApiVersionCondition) : (methodApiVersionCondition == null ? handlerTypeApiVersionCondition : methodApiVersionCondition);
        return apiVersionCondition;
    }

    private boolean doUseApiPath(Method method, Class<?> handlerType) {
        ApiRequestMapping apiRequestMappingM = (ApiRequestMapping)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, ApiRequestMapping.class);
        ApiRequestMapping apiRequestMappingT = (ApiRequestMapping)AnnotatedElementUtils.findMergedAnnotation(handlerType, ApiRequestMapping.class);
        return apiRequestMappingM != null || apiRequestMappingT != null;
    }

    private RequestMappingInfo createMappingForMethod(Method method, Class<?> handlerType) {
        RequestMappingInfo typeInfo;
        RequestMappingInfo info = this.createRequestMappingInfoFromMapper(method);
        if (info != null && (typeInfo = this.createRequestMappingInfoFromMapper(handlerType)) != null) {
            info = typeInfo.combine(info);
        }
        return info;
    }

    private RequestMappingInfo createRequestMappingInfoFromMapper(AnnotatedElement element) {
        RequestCondition condition = element instanceof Class ? this.getCustomTypeCondition((Class)element) : this.getCustomMethodCondition((Method)element);
        ApiRequestMapping apiRequestMapping = (ApiRequestMapping)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)element, ApiRequestMapping.class);
        if (apiRequestMapping != null) {
            return this.createRequestMappingInfo(new RequestMappingWrapper(apiRequestMapping), condition);
        }
        RequestMapping requestMapping = (RequestMapping)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)element, RequestMapping.class);
        if (requestMapping != null) {
            return this.createRequestMappingInfo(new RequestMappingWrapper(requestMapping), condition);
        }
        return null;
    }

    private RequestMappingInfo createRequestMappingInfo(RequestMappingWrapper requestMapper, RequestCondition<?> customCondition) {
        return RequestMappingInfo.paths((String[])this.resolveEmbeddedValuesInPatterns(requestMapper.getPaths())).methods(requestMapper.getMethods()).params(requestMapper.getParams()).headers(requestMapper.getHeaders()).consumes(requestMapper.getConsumes()).produces(requestMapper.getProduces()).mappingName(requestMapper.getName()).customCondition(customCondition).options(this.getBuilderConfig()).build();
    }

    private RequestMappingInfo.BuilderConfiguration getBuilderConfig() {
        RequestMappingInfo.BuilderConfiguration builderconfig = new RequestMappingInfo.BuilderConfiguration();
        builderconfig.setUrlPathHelper(this.getUrlPathHelper());
        builderconfig.setPathMatcher(this.getPathMatcher());
        builderconfig.setSuffixPatternMatch(this.useSuffixPatternMatch());
        builderconfig.setTrailingSlashMatch(this.useTrailingSlashMatch());
        builderconfig.setRegisteredSuffixPatternMatch(this.useRegisteredSuffixPatternMatch());
        builderconfig.setContentNegotiationManager(this.getContentNegotiationManager());
        return builderconfig;
    }

    private RequestMappingInfo getRequestMappingInfo(ApiVersionCondition apiVersionCondition, RequestMappingInfo info, boolean useApiPath) {
        RequestMappingInfo result = info;
        if (apiVersionCondition == null) {
            return result;
        }
        result = this.requestPathApiVersionInfo(apiVersionCondition, useApiPath, true).combine(info);
        return result;
    }

    private ApiVersionCondition getApiVersionCondition(Method method) {
        ApiVersion methodAnnotation = (ApiVersion)AnnotationUtils.findAnnotation((Method)method, ApiVersion.class);
        return this.getApiVersionCondition(methodAnnotation);
    }

    private ApiVersionCondition getApiVersionCondition(Class<?> handlerType) {
        ApiVersion typeAnnotation = (ApiVersion)AnnotationUtils.findAnnotation(handlerType, ApiVersion.class);
        return this.getApiVersionCondition(typeAnnotation);
    }

    private ApiVersionCondition getApiVersionCondition(ApiVersion annotation) {
        if (annotation == null) {
            return null;
        }
        Object[] values = annotation.value();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Creating condition for versions [" + StringUtils.join((Object[])values, (String)", ") + "], with supportted versions " + StringUtils.join((Object[])ApiVersioningConfiguration.getSupportedVersions(), (String)", ")));
        }
        return new ApiVersionCondition((String[])values, ApiVersioningConfiguration.getSupportedVersions());
    }

    private RequestMappingInfo requestParamApiVersionInfo(ApiVersionCondition apiVersionCondition, boolean useApiPath) {
        return new RequestMappingInfo(null, null, new ParamsRequestCondition((String[])Stream.of(apiVersionCondition.getVersions()).map(val -> "v=" + val).toArray(String[]::new)), null, null, null, null);
    }

    private RequestMappingInfo requestHeaderApiVersionInfo(ApiVersionCondition apiVersionCondition, boolean useApiPath) {
        return new RequestMappingInfo(null, null, null, new HeadersRequestCondition((String[])Stream.of(apiVersionCondition.getVersions()).map(val -> "v=" + val).toArray(String[]::new)), null, null, null);
    }

    private RequestMappingInfo requestPathApiVersionInfo(ApiVersionCondition apiVersionCondition, boolean useApiPath, boolean useVersionVar) {
        PatternsRequestCondition patternCondition = this.getApiPatternCondition(apiVersionCondition, useApiPath, useVersionVar);
        return new RequestMappingInfo(patternCondition, null, null, null, null, null, null);
    }

    private PatternsRequestCondition getApiPatternCondition(ApiVersionCondition apiVersionCondition, boolean useApiPath, boolean useVersionVar) {
        if (apiVersionCondition == null || !useApiPath) {
            return null;
        }
        return new PatternsRequestCondition(ApiPathHelper.getPaths(apiVersionCondition, useApiPath, useVersionVar));
    }
}

