/*
 * Decompiled with CFR 0.152.
 */
package net.chibidevteam.apiversioning.annotation;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import net.chibidevteam.apiversioning.annotation.ValidApiVersion;
import net.chibidevteam.apiversioning.config.ApiVersioningConfiguration;
import net.chibidevteam.apiversioning.util.helper.VersionHelper;

public class ApiVersionValidator
implements ConstraintValidator<ValidApiVersion, String> {
    private String[] allowedVersions;

    public void initialize(ValidApiVersion annotation) {
        this.allowedVersions = ApiVersioningConfiguration.getSupportedVersions();
    }

    public boolean isValid(String value, ConstraintValidatorContext ctx) {
        if (!VersionHelper.isVersion(value)) {
            return false;
        }
        return VersionHelper.match(value, this.allowedVersions, true);
    }
}

