/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.aspectj.annotation;

import java.io.Serializable;
import org.springframework.aop.aspectj.annotation.AspectMetadata;
import org.springframework.aop.aspectj.annotation.MetadataAwareAspectInstanceFactory;
import org.springframework.util.Assert;

public class LazySingletonAspectInstanceFactoryDecorator
implements MetadataAwareAspectInstanceFactory,
Serializable {
    private final MetadataAwareAspectInstanceFactory maaif;
    private volatile Object materialized;

    public LazySingletonAspectInstanceFactoryDecorator(MetadataAwareAspectInstanceFactory maaif) {
        Assert.notNull(maaif, "AspectInstanceFactory must not be null");
        this.maaif = maaif;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getAspectInstance() {
        if (this.materialized == null) {
            Object mutex = this.maaif.getAspectCreationMutex();
            if (mutex == null) {
                this.materialized = this.maaif.getAspectInstance();
            } else {
                Object object = mutex;
                synchronized (object) {
                    if (this.materialized == null) {
                        this.materialized = this.maaif.getAspectInstance();
                    }
                }
            }
        }
        return this.materialized;
    }

    public boolean isMaterialized() {
        return this.materialized != null;
    }

    @Override
    public ClassLoader getAspectClassLoader() {
        return this.maaif.getAspectClassLoader();
    }

    @Override
    public AspectMetadata getAspectMetadata() {
        return this.maaif.getAspectMetadata();
    }

    @Override
    public Object getAspectCreationMutex() {
        return this.maaif.getAspectCreationMutex();
    }

    @Override
    public int getOrder() {
        return this.maaif.getOrder();
    }

    public String toString() {
        return "LazySingletonAspectInstanceFactoryDecorator: decorating " + this.maaif;
    }
}

