/*
 * Decompiled with CFR 0.152.
 */
package net.chibidevteam.apiversioning.util.helper;

import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.chibidevteam.apiversioning.config.ApiVersioningConfiguration;
import net.chibidevteam.apiversioning.util.ApiVersionCondition;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class ApiPathHelper {
    private ApiPathHelper() {
    }

    private static String getApiPath(boolean useVersionVar) {
        String apiPath = ApiVersioningConfiguration.getApiPath();
        boolean hadLeadingSlash = apiPath.startsWith("/");
        boolean hadTrailingSlash = apiPath.endsWith("/");
        if (!useVersionVar) {
            apiPath = ApiPathHelper.removeVersionPathVariable(apiPath);
        }
        apiPath = hadLeadingSlash ? ApiPathHelper.prependSlash(apiPath) : ApiPathHelper.removeLeadingSlash(apiPath);
        apiPath = hadTrailingSlash ? ApiPathHelper.appendSlash(apiPath) : ApiPathHelper.removeTrailingSlash(apiPath);
        return apiPath;
    }

    public static String[] getPaths(ApiVersionCondition apiVersionCondition, boolean useApiPath, boolean useVersionVar) {
        if (!useApiPath) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        String[] result = new String[]{ApiPathHelper.getApiPath(useVersionVar)};
        if (apiVersionCondition == null) {
            return result;
        }
        TreeSet<String> set = new TreeSet<String>();
        Set<String> handledVersions = apiVersionCondition.getVersions();
        for (String path : result) {
            for (String version : handledVersions) {
                StringBuilder sb = new StringBuilder(ApiVersioningConfiguration.getVersionPathPrefix());
                sb.append(version);
                set.add(ApiPathHelper.replaceVersionPathVariable(path, sb.toString()));
            }
            if (!apiVersionCondition.doSupportLast()) continue;
            set.add(ApiPathHelper.removeVersionPathVariable(path));
        }
        return set.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    public static String translatePath(String path, String version, boolean useApiPath) {
        StringBuilder sb = new StringBuilder();
        if (useApiPath) {
            sb.append(ApiPathHelper.getApiPath(true));
        }
        sb.append(ApiPathHelper.prependSlash(path));
        if (StringUtils.isEmpty(version)) {
            return ApiPathHelper.removeVersionPathVariable(sb.toString());
        }
        String v = version;
        if (!v.startsWith(ApiVersioningConfiguration.getVersionPathPrefix())) {
            v = ApiVersioningConfiguration.getVersionPathPrefix() + v;
        }
        return ApiPathHelper.replaceVersionPathVariable(sb.toString(), v);
    }

    private static String removeVersionPathVariable(String path) {
        return ApiPathHelper.replaceVersionPathVariable(path, "");
    }

    private static String replaceVersionPathVariable(String path, String rplc) {
        String needle = ApiVersioningConfiguration.getVersionPathVariable();
        String needle2 = ApiVersioningConfiguration.getVersionPathVariableWithRegex();
        String p = path.replaceAll(Pattern.quote(needle), Matcher.quoteReplacement(rplc)).replaceAll(Pattern.quote(needle2), Matcher.quoteReplacement(rplc));
        return ApiPathHelper.removeDuplicatedSlash(p);
    }

    private static String removeDuplicatedSlash(String path) {
        return path.replaceAll("/+", "/");
    }

    private static String removeTrailingSlash(String path) {
        String result = path.trim();
        while (result.endsWith("/")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    private static String removeLeadingSlash(String path) {
        String result = path.trim();
        while (result.startsWith("/")) {
            result = result.substring(1);
        }
        return result;
    }

    private static String prependSlash(String path) {
        String result = path.trim();
        if (!result.startsWith("/")) {
            result = "/" + result;
        }
        return result;
    }

    private static String appendSlash(String path) {
        String result = path.trim();
        if (!result.endsWith("/")) {
            result = result + "/";
        }
        return result;
    }
}

