/*
 * Decompiled with CFR 0.152.
 */
package net.chibidevteam.apiversioning.util;

import java.util.Arrays;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import net.chibidevteam.apiversioning.util.helper.VersionHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ApiVersionCondition {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private SortedSet<String> versions = new TreeSet<String>();
    private SortedSet<String> supportedVersions = new TreeSet<String>();
    private boolean hasVersionsPattern = false;

    public ApiVersionCondition(String[] versions, String[] supportedVersions) {
        this(new TreeSet<String>(Arrays.asList(versions)), new TreeSet<String>(Arrays.asList(supportedVersions)));
    }

    public ApiVersionCondition(SortedSet<String> versions, SortedSet<String> supportedVersions) {
        SortedSet<String> newVersions = VersionHelper.getRealVersions(versions, supportedVersions);
        this.hasVersionsPattern = versions != null && !versions.isEmpty();
        this.versions.addAll(newVersions);
        this.supportedVersions.addAll(supportedVersions);
    }

    public boolean doSupportLast() {
        return !this.supportedVersions.isEmpty() && (!this.hasVersionsPattern || !this.versions.isEmpty() && VersionHelper.match(this.versions.last(), this.supportedVersions.last(), false));
    }

    public ApiVersionCondition restrictWith(ApiVersionCondition other) {
        this.versions.retainAll(other.versions);
        return new ApiVersionCondition(this.versions, this.supportedVersions);
    }

    public Set<String> getVersions() {
        return this.versions;
    }

    public Set<String> getSupportedVersions() {
        return this.supportedVersions;
    }

    public String toString() {
        return "ApiVersionCondition: { versions: [" + StringUtils.join(this.versions, ", ") + "], supportedVersions: [" + StringUtils.join(this.supportedVersions, ", ") + "] }";
    }
}

