/*
 * Decompiled with CFR 0.152.
 */
package net.chibidevteam.apiversioning.pojo;

import java.util.ArrayList;
import java.util.List;
import net.chibidevteam.apiversioning.util.helper.ClassHelper;
import org.apache.commons.lang3.StringUtils;

public class Version
implements Comparable<Version> {
    private Integer major;
    private Integer minor;
    private Integer patch;
    private List<String> others = new ArrayList<String>();

    public void setNext(String str) {
        if (StringUtils.isBlank(str)) {
            return;
        }
        if (str.matches("^\\d+$")) {
            if (this.major == null) {
                this.major = Integer.parseInt(str);
            } else if (this.minor == null) {
                this.minor = Integer.parseInt(str);
            } else if (this.patch == null) {
                this.patch = Integer.parseInt(str);
            }
        } else {
            this.others.add(str);
        }
    }

    public Integer getMajor() {
        return this.major;
    }

    public void setMajor(Integer major) {
        this.major = major;
    }

    public Integer getMinor() {
        return this.minor;
    }

    public void setMinor(Integer minor) {
        this.minor = minor;
    }

    public Integer getPatch() {
        return this.patch;
    }

    public void setPatch(Integer patch) {
        this.patch = patch;
    }

    public List<String> getOthers() {
        return this.others;
    }

    public void setOthers(List<String> others) {
        this.others = others;
    }

    public int hashCode() {
        return ClassHelper.hash(Version.class, this);
    }

    public boolean equals(Object obj) {
        return ClassHelper.areEquals(Version.class, this, obj);
    }

    @Override
    public int compareTo(Version v) {
        int vMinor;
        int vMajor;
        int myMajor = this.major == null ? 0 : this.major;
        int compMajor = myMajor - (vMajor = v.major == null ? 0 : v.major);
        if (compMajor != 0) {
            return compMajor;
        }
        int myMinor = this.minor == null ? 0 : this.minor;
        int compMinor = myMinor - (vMinor = v.minor == null ? 0 : v.minor);
        if (compMinor != 0) {
            return compMinor;
        }
        int myPatch = this.patch == null ? 0 : this.patch;
        int vPatch = v.patch == null ? 0 : v.patch;
        return myPatch - vPatch;
    }

    public String toString() {
        return "Version: { major: " + this.major + ", minor: " + this.minor + ", patch: " + this.patch + ", others: " + StringUtils.join(this.others, "") + " }";
    }
}

