/*
 * Decompiled with CFR 0.152.
 */
package net.chandol.logjdbc.logging.printer.sql.paramconverter;

import java.util.Date;
import net.chandol.logjdbc.logging.collector.parameter.Parameter;
import net.chandol.logjdbc.logging.collector.parameter.ParameterType;
import net.chandol.logjdbc.logging.printer.sql.paramconverter.BaseParameterConverter;
import net.chandol.logjdbc.logging.printer.sql.paramconverter.ConverterUtil;

public class OracleParameterConverter
extends BaseParameterConverter {
    @Override
    public String convert(Parameter parameter) {
        ParameterType type = parameter.getType();
        Object value = parameter.getValue();
        if (type.match(ParameterType._Timestamp)) {
            String formattedDate = ConverterUtil.dateFormat((Date)value, "yyyy/MM/dd HH:mm:ss.SSS");
            return "to_timestamp('" + formattedDate + "', 'yyyy/mm/dd hh24:mi:ss.ff3')";
        }
        if (type.match(ParameterType._Date)) {
            String formattedDate = ConverterUtil.dateFormat((Date)value, "yyyy/MM/dd HH:mm:ss");
            return "to_date('" + formattedDate + "', 'yyyy/mm/dd hh24:mi:ss')";
        }
        return super.convert(parameter);
    }
}

