/*
 * Decompiled with CFR 0.152.
 */
package net.chandol.logjdbc.logging.printer.sql.paramconverter;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.chandol.logjdbc.logging.collector.parameter.Parameter;
import net.chandol.logjdbc.logging.collector.parameter.ParameterType;
import net.chandol.logjdbc.logging.printer.sql.paramconverter.ConverterUtil;
import net.chandol.logjdbc.logging.printer.sql.paramconverter.ParameterConverter;

public class BaseParameterConverter
implements ParameterConverter {
    @Override
    public String convert(Parameter parameter) {
        ParameterType type = parameter.getType();
        Object value = parameter.getValue();
        if (!type.isConvertible()) {
            return "'" + value + "'";
        }
        if (value == null) {
            return "NULL";
        }
        if (type.match(ParameterType._Null)) {
            return "NULL";
        }
        if (type.match(ParameterType._String, ParameterType._NString)) {
            return ConverterUtil.strParam((String)value);
        }
        if (type.match(ParameterType._Date, ParameterType._Timestamp, ParameterType._Time)) {
            Date date = ConverterUtil.typeCast(value, Date.class);
            return ConverterUtil.strParam(ConverterUtil.dateFormat(date, "yyyy/MM/dd HH:mm:ss.SSS"));
        }
        if (type.match(ParameterType._Boolean)) {
            return ConverterUtil.typeCast(value, Boolean.class) != false ? "1" : "0";
        }
        return value.toString();
    }

    @Override
    public final List<String> convert(List<Parameter> parameters) {
        ArrayList<String> convertedParameters = new ArrayList<String>();
        for (Parameter parameter : parameters) {
            convertedParameters.add(this.convert(parameter));
        }
        return convertedParameters;
    }
}

