/*
 * Decompiled with CFR 0.152.
 */
package net.chandol.logjdbc.logging.printer.sql;

import java.util.List;
import net.chandol.logjdbc.config.LogJdbcConfig;
import net.chandol.logjdbc.logging.collector.parameter.Parameter;
import net.chandol.logjdbc.logging.collector.parameter.ParameterCollector;
import net.chandol.logjdbc.logging.printer.sql.SqlPrinter;
import net.chandol.logjdbc.logging.printer.sql.paramconverter.ParameterConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSqlPrinter
implements SqlPrinter {
    private static final Logger sqlLogger = LoggerFactory.getLogger((String)"net.chandol.logjdbc.sql");
    private static final Logger paramLogger = LoggerFactory.getLogger((String)"net.chandol.logjdbc.parameter");
    private static DefaultSqlPrinter defaultSqlPrinter;

    public static DefaultSqlPrinter getInstance() {
        if (defaultSqlPrinter == null) {
            defaultSqlPrinter = new DefaultSqlPrinter();
        }
        return defaultSqlPrinter;
    }

    private DefaultSqlPrinter() {
    }

    @Override
    public void logSql(LogJdbcConfig config, String templateSql, ParameterCollector parameterCollector) {
        ParameterConverter converter = config.getConverter();
        List<Parameter> params = parameterCollector.getAll();
        List<String> convertedParams = converter.convert(params);
        paramLogger.debug(DefaultSqlPrinter.parameterToLog(params, convertedParams));
        String sql = SqlParameterBinder.bind(templateSql, convertedParams);
        sql = DefaultSqlPrinter.checkFormattable(config, sql) ? config.getFormatter().format(sql) : "\n" + sql;
        if (config.getBooleanProperty("sql.trim.extra-linebreaks")) {
            sql = this.removeExtraLineBreak(sql);
        }
        sqlLogger.debug(sql);
    }

    String removeExtraLineBreak(String sql) {
        sql = sql.replaceAll("(\n){2,}", "\n");
        return sql;
    }

    @Override
    public void logSql(LogJdbcConfig config, String sql) {
        sql = DefaultSqlPrinter.checkFormattable(config, sql) ? config.getFormatter().format(sql) : "\n" + sql;
        sqlLogger.debug(sql);
    }

    static String parameterToLog(List<Parameter> params, List<String> convertedParams) {
        StringBuilder builder = new StringBuilder();
        builder.append("\nparameters : [");
        for (int idx = 0; idx < params.size(); ++idx) {
            String type = params.get(idx).getType().getTypeAsStr();
            String value = convertedParams.get(idx);
            builder.append("{").append(type).append(" = ").append(value).append("}");
            if (params.size() - 1 == idx) continue;
            builder.append(", ");
        }
        builder.append("]");
        return builder.toString();
    }

    private static boolean checkFormattable(LogJdbcConfig config, String sql) {
        boolean isFormatActive = config.getBooleanProperty("sql.auto.format.active");
        boolean isIgnoreFormattedSql = config.getBooleanProperty("sql.auto.format.ignore-formatted");
        if (isFormatActive) {
            return DefaultSqlPrinter.not(isIgnoreFormattedSql && DefaultSqlPrinter.isFormattedSql(sql));
        }
        return false;
    }

    private static boolean isFormattedSql(String sql) {
        return sql.contains("\n");
    }

    private static boolean not(boolean condition) {
        return !condition;
    }

    private static class SqlParameterBinder {
        private SqlParameterBinder() {
        }

        static String bind(String templateSql, List<String> params) {
            for (String param : params) {
                templateSql = templateSql.replaceFirst("\\?", param);
            }
            return templateSql;
        }
    }
}

