/*
 * Decompiled with CFR 0.152.
 */
package net.chandol.logjdbc.logging.printer.resultset;

import de.vandermeer.asciitable.v2.V2_AsciiTable;
import de.vandermeer.asciitable.v2.render.V2_AsciiTableRenderer;
import de.vandermeer.asciitable.v2.render.V2_Width;
import de.vandermeer.asciitable.v2.render.WidthLongestLine;
import de.vandermeer.asciitable.v2.themes.V2_E_TableThemes;
import java.util.List;
import net.chandol.logjdbc.config.LogJdbcConfig;
import net.chandol.logjdbc.logging.collector.resultset.ResultSetCollector;
import net.chandol.logjdbc.logging.collector.resultset.ResultSetData;
import net.chandol.logjdbc.logging.printer.resultset.ResultSetPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultSetTablePrinter
implements ResultSetPrinter {
    private static ResultSetTablePrinter instance;
    private static final Logger rsLogger;
    private V2_AsciiTableRenderer renderer = new V2_AsciiTableRenderer();

    public static ResultSetTablePrinter getInstance() {
        if (instance == null) {
            instance = new ResultSetTablePrinter();
        }
        return instance;
    }

    private ResultSetTablePrinter() {
        this.renderer.setTheme(V2_E_TableThemes.PLAIN_7BIT.get());
        this.renderer.setWidth((V2_Width)new WidthLongestLine());
    }

    @Override
    public void logResultSet(LogJdbcConfig config, ResultSetCollector collector) {
        ResultSetData data = collector.getResultSetData();
        int resultSetMaxLength = config.getIntProperty("resultset.maxlength");
        int printResultSetSize = Math.min(resultSetMaxLength, data.getRowsSize());
        String resultSetTable = this.getResultSetTable(data, printResultSetSize);
        rsLogger.debug("\n" + resultSetTable);
    }

    String getResultSetTable(ResultSetData data, int printResultSetSize) {
        List<String> columns = data.getColumns();
        List<String[]> rowValues = data.getRows();
        V2_AsciiTable table = new V2_AsciiTable();
        table.addRule();
        table.addRow(columns.toArray());
        table.addStrongRule();
        for (int idx = 0; idx < printResultSetSize; ++idx) {
            table.addRow((Object[])rowValues.get(idx));
        }
        table.addRule();
        return this.renderer.render(table).toString();
    }

    static {
        rsLogger = LoggerFactory.getLogger((String)"net.chandol.logjdbc.resultset");
    }
}

