/*
 * Decompiled with CFR 0.152.
 */
package net.chandol.logjdbc.logging.collector.resultset;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.chandol.logjdbc.except.LoggableDataSourceException;
import net.chandol.logjdbc.logging.collector.resultset.Column;

final class ResultSetUtil {
    ResultSetUtil() {
    }

    static List<Column> createColumns(ResultSetMetaData metaData) {
        try {
            ArrayList<Column> columns = new ArrayList<Column>();
            int count = ResultSetUtil.getColumnCount(metaData);
            for (int idx = 1; idx <= count; ++idx) {
                String label = metaData.getColumnLabel(idx);
                String type = metaData.getColumnTypeName(idx);
                columns.add(new Column(label, type));
            }
            return columns;
        }
        catch (SQLException e) {
            throw new LoggableDataSourceException(e);
        }
    }

    static int getColumnCount(ResultSetMetaData metaData) {
        try {
            return metaData.getColumnCount();
        }
        catch (SQLException e) {
            throw new LoggableDataSourceException(e);
        }
    }
}

