/*
 * Decompiled with CFR 0.152.
 */
package net.chandol.logjdbc.logging.collector.resultset;

import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.List;
import net.chandol.logjdbc.logging.collector.resultset.Column;
import net.chandol.logjdbc.logging.collector.resultset.ResultSetUtil;

public class ResultSetData {
    private List<Column> columns;
    private List<String[]> rows;

    ResultSetData(ResultSetMetaData metaData) {
        this.columns = ResultSetUtil.createColumns(metaData);
        this.rows = new ArrayList<String[]>();
    }

    void addRow(Object ... values) {
        String[] newValues = new String[values.length];
        for (int idx = 0; idx < values.length; ++idx) {
            newValues[idx] = values[idx] != null ? values[idx].toString() : "<null>";
        }
        this.rows.add(newValues);
    }

    public List<String> getColumns() {
        ArrayList<String> columnLabels = new ArrayList<String>();
        for (Column column : this.columns) {
            columnLabels.add(column.getLabel());
        }
        return columnLabels;
    }

    public int getRowsSize() {
        return this.rows.size();
    }

    public List<String[]> getRows() {
        return this.rows;
    }
}

