/*
 * Decompiled with CFR 0.152.
 */
package net.chandol.logjdbc.logging.collector.resultset;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import net.chandol.logjdbc.except.LoggableDataSourceException;
import net.chandol.logjdbc.logging.collector.resultset.ResultSetData;
import net.chandol.logjdbc.logging.collector.resultset.ResultSetUtil;

public class ResultSetCollector {
    private ResultSetData datas;
    private int columnCount;

    public ResultSetCollector(ResultSetMetaData metaData) {
        this.datas = new ResultSetData(metaData);
        this.columnCount = ResultSetUtil.getColumnCount(metaData);
    }

    public void collectCurrentCursorResultSetData(ResultSet resultSet) {
        try {
            Object[] values = new Object[this.columnCount];
            for (int idx = 0; idx < this.columnCount; ++idx) {
                values[idx] = resultSet.getObject(idx + 1);
            }
            this.datas.addRow(values);
        }
        catch (SQLException e) {
            throw new LoggableDataSourceException(e);
        }
    }

    public ResultSetData getResultSetData() {
        return this.datas;
    }
}

