/*
 * Decompiled with CFR 0.152.
 */
package net.chandol.logjdbc.logging;

import java.sql.ResultSetMetaData;
import net.chandol.logjdbc.config.LogJdbcConfig;
import net.chandol.logjdbc.logging.collector.parameter.ParameterCollector;
import net.chandol.logjdbc.logging.collector.resultset.ResultSetCollector;
import net.chandol.logjdbc.logging.printer.LogPrinter;

public class LogContext {
    private LogJdbcConfig config;
    private String sql;
    private ResultSetCollector resultSetCollector;
    private ParameterCollector parameterCollector;

    public void printLog() {
        if (this.parameterCollector != null) {
            LogPrinter.logSql(this.config, this.sql, this.parameterCollector);
        } else if (this.isSqlExist()) {
            LogPrinter.logSql(this.config, this.sql);
        }
        if (this.resultSetCollector != null) {
            LogPrinter.logResultSet(this.config, this.resultSetCollector);
        }
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public ParameterCollector initParameterCollector() {
        this.parameterCollector = new ParameterCollector();
        return this.parameterCollector;
    }

    public ResultSetCollector initResultSetCollector(ResultSetMetaData metaData) {
        this.resultSetCollector = new ResultSetCollector(metaData);
        return this.resultSetCollector;
    }

    private boolean isSqlExist() {
        return this.sql != null && !this.sql.isEmpty();
    }

    private LogContext(LogJdbcConfig config) {
        this.config = config;
    }

    private LogContext(LogJdbcConfig config, String sql) {
        this.config = config;
        this.sql = sql;
    }

    public static LogContext of(LogJdbcConfig config) {
        return new LogContext(config);
    }

    public static LogContext of(LogJdbcConfig config, String sql) {
        return new LogContext(config, sql);
    }
}

