/*
 * Decompiled with CFR 0.152.
 */
package net.chandol.logjdbc.jdbcproxy;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import net.chandol.logjdbc.jdbcproxy.ProxyResultSet;
import net.chandol.logjdbc.logging.LogContext;

public class ProxyStatement
implements Statement {
    private Statement _stmt;
    protected LogContext context;

    public ProxyStatement(LogContext context, Statement statement) {
        this.context = context;
        this._stmt = statement;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        try {
            this.context.setSql(sql);
            ResultSet resultSet = this._stmt.executeQuery(sql);
            return new ProxyResultSet(this.context, resultSet);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        try {
            this.context.setSql(sql);
            this._stmt.addBatch(sql);
        }
        finally {
            this.context.printLog();
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        try {
            this.context.setSql(sql);
            int n = this._stmt.executeUpdate(sql);
            return n;
        }
        finally {
            this.context.printLog();
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        try {
            this.context.setSql(sql);
            boolean bl = this._stmt.execute(sql);
            return bl;
        }
        finally {
            this.context.printLog();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            this.context.setSql(sql);
            int n = this._stmt.executeUpdate(sql, autoGeneratedKeys);
            return n;
        }
        finally {
            this.context.printLog();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        try {
            this.context.setSql(sql);
            int n = this._stmt.executeUpdate(sql, columnIndexes);
            return n;
        }
        finally {
            this.context.printLog();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        try {
            this.context.setSql(sql);
            int n = this._stmt.executeUpdate(sql, columnNames);
            return n;
        }
        finally {
            this.context.printLog();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            this.context.setSql(sql);
            boolean bl = this._stmt.execute(sql, autoGeneratedKeys);
            return bl;
        }
        finally {
            this.context.printLog();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        try {
            this.context.setSql(sql);
            boolean bl = this._stmt.execute(sql, columnIndexes);
            return bl;
        }
        finally {
            this.context.printLog();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        try {
            this.context.setSql(sql);
            boolean bl = this._stmt.execute(sql, columnNames);
            return bl;
        }
        finally {
            this.context.printLog();
        }
    }

    @Override
    public void close() throws SQLException {
        this._stmt.close();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this._stmt.getMaxFieldSize();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this._stmt.setMaxFieldSize(max);
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this._stmt.getMaxRows();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this._stmt.setMaxRows(max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this._stmt.setEscapeProcessing(enable);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this._stmt.getQueryTimeout();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this._stmt.setQueryTimeout(seconds);
    }

    @Override
    public void cancel() throws SQLException {
        this._stmt.cancel();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this._stmt.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this._stmt.clearWarnings();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this._stmt.setCursorName(name);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this._stmt.getResultSet();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this._stmt.getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this._stmt.getMoreResults();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this._stmt.setFetchDirection(direction);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this._stmt.getFetchDirection();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this._stmt.setFetchSize(rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this._stmt.getFetchSize();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this._stmt.getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this._stmt.getResultSetType();
    }

    @Override
    public void clearBatch() throws SQLException {
        this._stmt.clearBatch();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return this._stmt.executeBatch();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this._stmt.getConnection();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return this._stmt.getMoreResults(current);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return this._stmt.getGeneratedKeys();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this._stmt.getResultSetHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this._stmt.isClosed();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this._stmt.setPoolable(poolable);
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this._stmt.isPoolable();
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this._stmt.closeOnCompletion();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this._stmt.isCloseOnCompletion();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this._stmt.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this._stmt.isWrapperFor(iface);
    }
}

