/*
 * Decompiled with CFR 0.152.
 */
package net.chandol.logjdbc.jdbcproxy;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import net.chandol.logjdbc.except.LoggableDataSourceException;
import net.chandol.logjdbc.logging.LogContext;
import net.chandol.logjdbc.logging.collector.resultset.ResultSetCollector;

public class ProxyResultSet
implements ResultSet {
    private ResultSet _resultSet;
    private ResultSetCollector rsCollector;
    private LogContext context;

    ProxyResultSet(LogContext context, ResultSet resultSet) {
        this.context = context;
        this._resultSet = resultSet;
        try {
            this.rsCollector = context.initResultSetCollector(this.getMetaData());
        }
        catch (SQLException e) {
            context.printLog();
            throw new LoggableDataSourceException(e);
        }
    }

    @Override
    public boolean next() throws SQLException {
        try {
            boolean hasNext = this._resultSet.next();
            if (hasNext) {
                this.rsCollector.collectCurrentCursorResultSetData(this);
            }
            return hasNext;
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            this._resultSet.close();
        }
        finally {
            this.context.printLog();
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        try {
            return this._resultSet.wasNull();
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        try {
            return this._resultSet.getString(columnIndex);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        try {
            return this._resultSet.getBoolean(columnIndex);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        try {
            return this._resultSet.getByte(columnIndex);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        try {
            return this._resultSet.getShort(columnIndex);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        try {
            return this._resultSet.getInt(columnIndex);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        try {
            return this._resultSet.getLong(columnIndex);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        try {
            return this._resultSet.getFloat(columnIndex);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        try {
            return this._resultSet.getDouble(columnIndex);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        try {
            return this._resultSet.getBigDecimal(columnIndex, scale);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        try {
            return this._resultSet.getBytes(columnIndex);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        try {
            return this._resultSet.getDate(columnIndex);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        try {
            return this._resultSet.getTime(columnIndex);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        try {
            return this._resultSet.getTimestamp(columnIndex);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        try {
            return this._resultSet.getAsciiStream(columnIndex);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        try {
            return this._resultSet.getUnicodeStream(columnIndex);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        try {
            return this._resultSet.getBinaryStream(columnIndex);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        try {
            return this._resultSet.getString(columnLabel);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        try {
            return this._resultSet.getBoolean(columnLabel);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        try {
            return this._resultSet.getByte(columnLabel);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        try {
            return this._resultSet.getShort(columnLabel);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        try {
            return this._resultSet.getInt(columnLabel);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        try {
            return this._resultSet.getLong(columnLabel);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        try {
            return this._resultSet.getFloat(columnLabel);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        try {
            return this._resultSet.getDouble(columnLabel);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        try {
            return this._resultSet.getBigDecimal(columnLabel);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        try {
            return this._resultSet.getBytes(columnLabel);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        try {
            return this._resultSet.getDate(columnLabel);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        try {
            return this._resultSet.getTime(columnLabel);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        try {
            return this._resultSet.getTimestamp(columnLabel);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        try {
            return this._resultSet.getAsciiStream(columnLabel);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        try {
            return this._resultSet.getUnicodeStream(columnLabel);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        try {
            return this._resultSet.getBinaryStream(columnLabel);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            return this._resultSet.getWarnings();
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            this._resultSet.clearWarnings();
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public String getCursorName() throws SQLException {
        try {
            return this._resultSet.getCursorName();
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            return this._resultSet.getMetaData();
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        try {
            return this._resultSet.getObject(columnIndex);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        try {
            return this._resultSet.getObject(columnLabel);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        try {
            return this._resultSet.findColumn(columnLabel);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        try {
            return this._resultSet.getCharacterStream(columnIndex);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        try {
            return this._resultSet.getCharacterStream(columnLabel);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        try {
            return this._resultSet.getBigDecimal(columnIndex);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        try {
            return this._resultSet.getBigDecimal(columnLabel);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        try {
            return this._resultSet.isBeforeFirst();
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        try {
            return this._resultSet.isAfterLast();
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public boolean isFirst() throws SQLException {
        try {
            return this._resultSet.isFirst();
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public boolean isLast() throws SQLException {
        try {
            return this._resultSet.isLast();
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void beforeFirst() throws SQLException {
        try {
            this._resultSet.beforeFirst();
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void afterLast() throws SQLException {
        try {
            this._resultSet.afterLast();
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public boolean first() throws SQLException {
        try {
            return this._resultSet.first();
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public boolean last() throws SQLException {
        try {
            return this._resultSet.last();
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public int getRow() throws SQLException {
        try {
            return this._resultSet.getRow();
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        try {
            return this._resultSet.absolute(row);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        try {
            return this._resultSet.relative(rows);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public boolean previous() throws SQLException {
        try {
            return this._resultSet.previous();
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        try {
            this._resultSet.setFetchDirection(direction);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        try {
            return this._resultSet.getFetchDirection();
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        try {
            this._resultSet.setFetchSize(rows);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        try {
            return this._resultSet.getFetchSize();
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public int getType() throws SQLException {
        try {
            return this._resultSet.getType();
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public int getConcurrency() throws SQLException {
        try {
            return this._resultSet.getConcurrency();
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        try {
            return this._resultSet.rowUpdated();
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public boolean rowInserted() throws SQLException {
        try {
            return this._resultSet.rowInserted();
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        try {
            return this._resultSet.rowDeleted();
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        try {
            this._resultSet.updateNull(columnIndex);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        try {
            this._resultSet.updateBoolean(columnIndex, x);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        try {
            this._resultSet.updateByte(columnIndex, x);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        try {
            this._resultSet.updateShort(columnIndex, x);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        try {
            this._resultSet.updateInt(columnIndex, x);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        try {
            this._resultSet.updateLong(columnIndex, x);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        this._resultSet.updateFloat(columnIndex, x);
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        try {
            this._resultSet.updateDouble(columnIndex, x);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        try {
            this._resultSet.updateBigDecimal(columnIndex, x);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        try {
            this._resultSet.updateString(columnIndex, x);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        try {
            this._resultSet.updateBytes(columnIndex, x);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        try {
            this._resultSet.updateDate(columnIndex, x);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        try {
            this._resultSet.updateTime(columnIndex, x);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        try {
            this._resultSet.updateTimestamp(columnIndex, x);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        try {
            this._resultSet.updateAsciiStream(columnIndex, x, length);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        try {
            this._resultSet.updateBinaryStream(columnIndex, x, length);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        try {
            this._resultSet.updateCharacterStream(columnIndex, x, length);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        try {
            this._resultSet.updateObject(columnIndex, x, scaleOrLength);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        try {
            this._resultSet.updateObject(columnIndex, x);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        try {
            this._resultSet.updateNull(columnLabel);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        try {
            this._resultSet.updateBoolean(columnLabel, x);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        try {
            this._resultSet.updateByte(columnLabel, x);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        try {
            this._resultSet.updateShort(columnLabel, x);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        try {
            this._resultSet.updateInt(columnLabel, x);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        try {
            this._resultSet.updateLong(columnLabel, x);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        try {
            this._resultSet.updateFloat(columnLabel, x);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        try {
            this._resultSet.updateDouble(columnLabel, x);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        try {
            this._resultSet.updateBigDecimal(columnLabel, x);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        try {
            this._resultSet.updateString(columnLabel, x);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        try {
            this._resultSet.updateBytes(columnLabel, x);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        try {
            this._resultSet.updateDate(columnLabel, x);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        try {
            this._resultSet.updateTime(columnLabel, x);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        try {
            this._resultSet.updateTimestamp(columnLabel, x);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        try {
            this._resultSet.updateAsciiStream(columnLabel, x, length);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        try {
            this._resultSet.updateBinaryStream(columnLabel, x, length);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        try {
            this._resultSet.updateCharacterStream(columnLabel, reader, length);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        try {
            this._resultSet.updateObject(columnLabel, x, scaleOrLength);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        try {
            this._resultSet.updateObject(columnLabel, x);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void insertRow() throws SQLException {
        try {
            this._resultSet.insertRow();
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateRow() throws SQLException {
        try {
            this._resultSet.updateRow();
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void deleteRow() throws SQLException {
        try {
            this._resultSet.deleteRow();
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void refreshRow() throws SQLException {
        try {
            this._resultSet.refreshRow();
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        try {
            this._resultSet.cancelRowUpdates();
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        try {
            this._resultSet.moveToInsertRow();
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        try {
            this._resultSet.moveToCurrentRow();
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public Statement getStatement() throws SQLException {
        try {
            return this._resultSet.getStatement();
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        try {
            return this._resultSet.getObject(columnIndex, map);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        try {
            return this._resultSet.getRef(columnIndex);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        try {
            return this._resultSet.getBlob(columnIndex);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        try {
            return this._resultSet.getClob(columnIndex);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        try {
            return this._resultSet.getArray(columnIndex);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        try {
            return this._resultSet.getObject(columnLabel, map);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        try {
            return this._resultSet.getRef(columnLabel);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        try {
            return this._resultSet.getBlob(columnLabel);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        try {
            return this._resultSet.getClob(columnLabel);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        try {
            return this._resultSet.getArray(columnLabel);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        try {
            return this._resultSet.getDate(columnIndex, cal);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        try {
            return this._resultSet.getDate(columnLabel, cal);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        try {
            return this._resultSet.getTime(columnIndex, cal);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        try {
            return this._resultSet.getTime(columnLabel, cal);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        try {
            return this._resultSet.getTimestamp(columnIndex, cal);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        try {
            return this._resultSet.getTimestamp(columnLabel, cal);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        try {
            return this._resultSet.getURL(columnIndex);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        try {
            return this._resultSet.getURL(columnLabel);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        try {
            this._resultSet.updateRef(columnIndex, x);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        try {
            this._resultSet.updateRef(columnLabel, x);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        try {
            this._resultSet.updateBlob(columnIndex, x);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        try {
            this._resultSet.updateBlob(columnLabel, x);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        try {
            this._resultSet.updateClob(columnIndex, x);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        try {
            this._resultSet.updateClob(columnLabel, x);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        try {
            this._resultSet.updateArray(columnIndex, x);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        try {
            this._resultSet.updateArray(columnLabel, x);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        try {
            return this._resultSet.getRowId(columnIndex);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        try {
            return this._resultSet.getRowId(columnLabel);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        try {
            this._resultSet.updateRowId(columnIndex, x);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        try {
            this._resultSet.updateRowId(columnLabel, x);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        try {
            return this._resultSet.getHoldability();
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        try {
            return this._resultSet.isClosed();
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        try {
            this._resultSet.updateNString(columnIndex, nString);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        try {
            this._resultSet.updateNString(columnLabel, nString);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        try {
            this._resultSet.updateNClob(columnIndex, nClob);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        try {
            this._resultSet.updateNClob(columnLabel, nClob);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        try {
            return this._resultSet.getNClob(columnIndex);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        try {
            return this._resultSet.getNClob(columnLabel);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        try {
            return this._resultSet.getSQLXML(columnIndex);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        try {
            return this._resultSet.getSQLXML(columnLabel);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        try {
            this._resultSet.updateSQLXML(columnIndex, xmlObject);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        try {
            this._resultSet.updateSQLXML(columnLabel, xmlObject);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        try {
            return this._resultSet.getNString(columnIndex);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        try {
            return this._resultSet.getNString(columnLabel);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        try {
            return this._resultSet.getNCharacterStream(columnIndex);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        try {
            return this._resultSet.getNCharacterStream(columnLabel);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        try {
            this._resultSet.updateNCharacterStream(columnIndex, x, length);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        try {
            this._resultSet.updateNCharacterStream(columnLabel, reader, length);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        try {
            this._resultSet.updateAsciiStream(columnIndex, x, length);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        try {
            this._resultSet.updateBinaryStream(columnIndex, x, length);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        try {
            this._resultSet.updateCharacterStream(columnIndex, x, length);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        try {
            this._resultSet.updateAsciiStream(columnLabel, x, length);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        try {
            this._resultSet.updateBinaryStream(columnLabel, x, length);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        try {
            this._resultSet.updateCharacterStream(columnLabel, reader, length);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        try {
            this._resultSet.updateBlob(columnIndex, inputStream, length);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        try {
            this._resultSet.updateBlob(columnLabel, inputStream, length);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        try {
            this._resultSet.updateClob(columnIndex, reader, length);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        try {
            this._resultSet.updateClob(columnLabel, reader, length);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        try {
            this._resultSet.updateNClob(columnIndex, reader, length);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        try {
            this._resultSet.updateNClob(columnLabel, reader, length);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        try {
            this._resultSet.updateNCharacterStream(columnIndex, x);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        try {
            this._resultSet.updateNCharacterStream(columnLabel, reader);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        try {
            this._resultSet.updateAsciiStream(columnIndex, x);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        try {
            this._resultSet.updateBinaryStream(columnIndex, x);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        try {
            this._resultSet.updateCharacterStream(columnIndex, x);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        try {
            this._resultSet.updateAsciiStream(columnLabel, x);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        try {
            this._resultSet.updateBinaryStream(columnLabel, x);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        try {
            this._resultSet.updateCharacterStream(columnLabel, reader);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        try {
            this._resultSet.updateBlob(columnIndex, inputStream);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        try {
            this._resultSet.updateBlob(columnLabel, inputStream);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        try {
            this._resultSet.updateClob(columnIndex, reader);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        try {
            this._resultSet.updateClob(columnLabel, reader);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        try {
            this._resultSet.updateNClob(columnIndex, reader);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        try {
            this._resultSet.updateNClob(columnLabel, reader);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        try {
            return this._resultSet.getObject(columnIndex, type);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        try {
            return this._resultSet.getObject(columnLabel, type);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return this._resultSet.unwrap(iface);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        try {
            return this._resultSet.isWrapperFor(iface);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }
}

