/*
 * Decompiled with CFR 0.152.
 */
package net.chandol.logjdbc.jdbcproxy;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import net.chandol.logjdbc.jdbcproxy.ProxyResultSet;
import net.chandol.logjdbc.jdbcproxy.ProxyStatement;
import net.chandol.logjdbc.logging.LogContext;
import net.chandol.logjdbc.logging.collector.parameter.ParameterCollector;
import net.chandol.logjdbc.logging.collector.parameter.ParameterType;

public class ProxyPreparedStatement
extends ProxyStatement
implements PreparedStatement {
    private PreparedStatement _pstmt;
    private ParameterCollector paramCollector;

    public ProxyPreparedStatement(LogContext context, PreparedStatement preparedStatement) {
        super(context, preparedStatement);
        this._pstmt = preparedStatement;
        this.paramCollector = context.initParameterCollector();
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        try {
            ResultSet resultSet = this._pstmt.executeQuery();
            return new ProxyResultSet(this.context, resultSet);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public int executeUpdate() throws SQLException {
        try {
            int n = this._pstmt.executeUpdate();
            return n;
        }
        finally {
            this.context.printLog();
        }
    }

    @Override
    public boolean execute() throws SQLException {
        try {
            boolean bl = this._pstmt.execute();
            return bl;
        }
        finally {
            this.context.printLog();
        }
    }

    @Override
    public void setNull(int index, int sqlType) throws SQLException {
        try {
            this._pstmt.setNull(index, sqlType);
            this.paramCollector.add(index, ParameterType._Null, null);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void setBoolean(int index, boolean x) throws SQLException {
        try {
            this._pstmt.setBoolean(index, x);
            this.paramCollector.add(index, ParameterType._Boolean, x);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void setByte(int index, byte x) throws SQLException {
        try {
            this._pstmt.setByte(index, x);
            this.paramCollector.add(index, ParameterType._Byte, x);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void setShort(int index, short x) throws SQLException {
        try {
            this._pstmt.setShort(index, x);
            this.paramCollector.add(index, ParameterType._Short, x);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void setInt(int index, int x) throws SQLException {
        try {
            this._pstmt.setInt(index, x);
            this.paramCollector.add(index, ParameterType._Int, x);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void setLong(int index, long x) throws SQLException {
        try {
            this._pstmt.setLong(index, x);
            this.paramCollector.add(index, ParameterType._Long, x);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void setFloat(int index, float x) throws SQLException {
        try {
            this._pstmt.setFloat(index, x);
            this.paramCollector.add(index, ParameterType._Float, Float.valueOf(x));
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void setDouble(int index, double x) throws SQLException {
        try {
            this._pstmt.setDouble(index, x);
            this.paramCollector.add(index, ParameterType._Double, x);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void setBigDecimal(int index, BigDecimal x) throws SQLException {
        try {
            this._pstmt.setBigDecimal(index, x);
            this.paramCollector.add(index, ParameterType._BigDecimal, x);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void setString(int index, String x) throws SQLException {
        try {
            this._pstmt.setString(index, x);
            this.paramCollector.add(index, ParameterType._String, x);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void setBytes(int index, byte[] x) throws SQLException {
        try {
            this._pstmt.setBytes(index, x);
            this.paramCollector.add(index, ParameterType._Bytes, "<byte[]>");
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void setDate(int index, Date x) throws SQLException {
        try {
            this._pstmt.setDate(index, x);
            this.paramCollector.add(index, ParameterType._Date, x);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void setTime(int index, Time x) throws SQLException {
        try {
            this._pstmt.setTime(index, x);
            this.paramCollector.add(index, ParameterType._Time, x);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void setTimestamp(int index, Timestamp x) throws SQLException {
        try {
            this._pstmt.setTimestamp(index, x);
            this.paramCollector.add(index, ParameterType._Timestamp, x);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void setAsciiStream(int index, InputStream x, int length) throws SQLException {
        try {
            this._pstmt.setAsciiStream(index, x, length);
            this.paramCollector.add(index, ParameterType._AsciiStream, "<AsciiStream length : " + length + ">");
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void setUnicodeStream(int index, InputStream x, int length) throws SQLException {
        try {
            this._pstmt.setUnicodeStream(index, x, length);
            this.paramCollector.add(index, ParameterType.UnicodeStream, "<UnicodeStream length : " + length + ">");
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void setBinaryStream(int index, InputStream x, int length) throws SQLException {
        try {
            this._pstmt.setBinaryStream(index, x, length);
            this.paramCollector.add(index, ParameterType._BinaryStream, "<BinaryStream length : " + length + ">");
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void setObject(int index, Object x, int targetSqlType) throws SQLException {
        try {
            this._pstmt.setObject(index, x, targetSqlType);
            this.paramCollector.add(index, ParameterType._Object, "<Object>");
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void setObject(int index, Object x) throws SQLException {
        try {
            this._pstmt.setObject(index, x);
            this.paramCollector.add(index, ParameterType._Object, "<Object>");
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void setCharacterStream(int index, Reader reader, int length) throws SQLException {
        try {
            this._pstmt.setCharacterStream(index, reader, length);
            this.paramCollector.add(index, ParameterType._CharacterStream, "<CharacterStream length : " + length + ">");
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void setRef(int index, Ref x) throws SQLException {
        try {
            this._pstmt.setRef(index, x);
            this.paramCollector.add(index, ParameterType._Ref, x);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void setBlob(int index, Blob x) throws SQLException {
        try {
            this._pstmt.setBlob(index, x);
            this.paramCollector.add(index, ParameterType._Blob, "<Blob of size " + x.length() + ">");
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void setClob(int index, Clob x) throws SQLException {
        try {
            this._pstmt.setClob(index, x);
            this.paramCollector.add(index, ParameterType._Clob, "<Clob of size " + x.length() + ">");
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void setArray(int index, Array x) throws SQLException {
        try {
            this._pstmt.setArray(index, x);
            this.paramCollector.add(index, ParameterType._Array, "<Array>");
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void setDate(int index, Date x, Calendar cal) throws SQLException {
        try {
            this._pstmt.setDate(index, x, cal);
            this.paramCollector.add(index, ParameterType._Date, x);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void setTime(int index, Time x, Calendar cal) throws SQLException {
        try {
            this._pstmt.setTime(index, x, cal);
            this.paramCollector.add(index, ParameterType._Time, x);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void setTimestamp(int index, Timestamp x, Calendar cal) throws SQLException {
        try {
            this._pstmt.setTimestamp(index, x, cal);
            this.paramCollector.add(index, ParameterType._Timestamp, x);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void setNull(int index, int sqlType, String typeName) throws SQLException {
        try {
            this._pstmt.setNull(index, sqlType, typeName);
            this.paramCollector.add(index, ParameterType._Null, null);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void setURL(int index, URL x) throws SQLException {
        try {
            this._pstmt.setURL(index, x);
            this.paramCollector.add(index, ParameterType._URL, x);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void setRowId(int index, RowId x) throws SQLException {
        try {
            this._pstmt.setRowId(index, x);
            this.paramCollector.add(index, ParameterType._RowId, x);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void setNString(int index, String value) throws SQLException {
        try {
            this._pstmt.setNString(index, value);
            this.paramCollector.add(index, ParameterType._NString, value);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void setNCharacterStream(int index, Reader value, long length) throws SQLException {
        try {
            this._pstmt.setNCharacterStream(index, value, length);
            this.paramCollector.add(index, ParameterType._NCharacterStream, "<Reader of length " + length + ">");
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void setNClob(int index, NClob value) throws SQLException {
        try {
            this._pstmt.setNClob(index, value);
            this.paramCollector.add(index, ParameterType._NClob, "<NClob>");
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void setClob(int index, Reader reader, long length) throws SQLException {
        try {
            this._pstmt.setClob(index, reader, length);
            this.paramCollector.add(index, ParameterType._Clob, "<Reader>");
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void setBlob(int index, InputStream inputStream, long length) throws SQLException {
        try {
            this._pstmt.setBlob(index, inputStream, length);
            this.paramCollector.add(index, ParameterType._Blob, "<InputStream length : " + length + ">");
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void setNClob(int index, Reader reader, long length) throws SQLException {
        try {
            this._pstmt.setNClob(index, reader, length);
            this.paramCollector.add(index, ParameterType._NClob, "<Reader length : " + length + ">");
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void setSQLXML(int index, SQLXML xmlObject) throws SQLException {
        try {
            this._pstmt.setSQLXML(index, xmlObject);
            this.paramCollector.add(index, ParameterType._SQLXML, xmlObject);
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void setObject(int index, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        try {
            this._pstmt.setObject(index, x, targetSqlType, scaleOrLength);
            this.paramCollector.add(index, ParameterType._Object, "<Object>");
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void setAsciiStream(int index, InputStream x, long length) throws SQLException {
        try {
            this._pstmt.setAsciiStream(index, x, length);
            this.paramCollector.add(index, ParameterType._AsciiStream, "<InputStream length : " + length + ">");
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void setBinaryStream(int index, InputStream x, long length) throws SQLException {
        try {
            this._pstmt.setBinaryStream(index, x, length);
            this.paramCollector.add(index, ParameterType._BinaryStream, "<InputStream length : " + length + ">");
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void setCharacterStream(int index, Reader reader, long length) throws SQLException {
        try {
            this._pstmt.setCharacterStream(index, reader, length);
            this.paramCollector.add(index, ParameterType._CharacterStream, "<Reader length : " + length + ">");
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void setAsciiStream(int index, InputStream x) throws SQLException {
        try {
            this._pstmt.setAsciiStream(index, x);
            this.paramCollector.add(index, ParameterType._AsciiStream, "<InputStream>");
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void setBinaryStream(int index, InputStream x) throws SQLException {
        try {
            this._pstmt.setBinaryStream(index, x);
            this.paramCollector.add(index, ParameterType._BinaryStream, "<InputStream>");
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void setCharacterStream(int index, Reader reader) throws SQLException {
        try {
            this._pstmt.setCharacterStream(index, reader);
            this.paramCollector.add(index, ParameterType._CharacterStream, "<Reader>");
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void setNCharacterStream(int index, Reader value) throws SQLException {
        try {
            this._pstmt.setNCharacterStream(index, value);
            this.paramCollector.add(index, ParameterType._NCharacterStream, "<Reader>");
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void setClob(int index, Reader reader) throws SQLException {
        try {
            this._pstmt.setClob(index, reader);
            this.paramCollector.add(index, ParameterType._Clob, "<Reader>");
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void setBlob(int index, InputStream inputStream) throws SQLException {
        try {
            this._pstmt.setBlob(index, inputStream);
            this.paramCollector.add(index, ParameterType._Blob, "<InputStream>");
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void setNClob(int index, Reader reader) throws SQLException {
        try {
            this._pstmt.setNClob(index, reader);
            this.paramCollector.add(index, ParameterType._NClob, "<Reader>");
        }
        catch (SQLException e) {
            this.context.printLog();
            throw e;
        }
    }

    @Override
    public void clearParameters() throws SQLException {
        this._pstmt.clearParameters();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this._pstmt.getMetaData();
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this._pstmt.getParameterMetaData();
    }

    @Override
    public void addBatch() throws SQLException {
        this._pstmt.addBatch();
    }
}

