/*
 * Decompiled with CFR 0.152.
 */
package net.chandol.logjdbc.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import net.chandol.logjdbc.config.DatabaseType;
import net.chandol.logjdbc.config.LogJdbcConfigDefaultProperties;
import net.chandol.logjdbc.logging.printer.resultset.ResultSetPrinter;
import net.chandol.logjdbc.logging.printer.resultset.ResultSetTablePrinter;
import net.chandol.logjdbc.logging.printer.sql.DefaultSqlPrinter;
import net.chandol.logjdbc.logging.printer.sql.SqlPrinter;
import net.chandol.logjdbc.logging.printer.sql.formatter.DefaultSqlFormatter;
import net.chandol.logjdbc.logging.printer.sql.formatter.SqlFormatter;
import net.chandol.logjdbc.logging.printer.sql.paramconverter.ParameterConverter;

public class LogJdbcConfig {
    private DatabaseType type;
    private ParameterConverter converter;
    private SqlFormatter formatter = DefaultSqlFormatter.getInstance();
    private SqlPrinter sqlPrinter = DefaultSqlPrinter.getInstance();
    private ResultSetPrinter resultSetPrinter = ResultSetTablePrinter.getInstance();
    private Map<String, String> properties;

    public LogJdbcConfig() {
        this(new HashMap<String, String>());
    }

    public LogJdbcConfig(DatabaseType type) {
        this(type, new HashMap<String, String>());
    }

    public LogJdbcConfig(Map<String, String> properties) {
        this.properties = Collections.unmodifiableMap(LogJdbcConfig.combinePropertiesMap(properties));
    }

    public LogJdbcConfig(DatabaseType type, Map<String, String> properties) {
        this(properties);
        this.type = type;
        this.converter = type.getParameterConverter();
    }

    public DatabaseType getType() {
        return this.type;
    }

    public ParameterConverter getConverter() {
        return this.converter;
    }

    public SqlFormatter getFormatter() {
        return this.formatter;
    }

    public SqlPrinter getSqlPrinter() {
        return this.sqlPrinter;
    }

    public ResultSetPrinter getResultSetPrinter() {
        return this.resultSetPrinter;
    }

    public boolean getBooleanProperty(String key) {
        String value = this.getProperty(key);
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        throw new IllegalArgumentException("cannot convert to boolean : " + value);
    }

    public int getIntProperty(String key) {
        return Integer.valueOf(this.getProperty(key));
    }

    public String getProperty(String key) {
        return this.properties.get(key);
    }

    public void setDatabaseTypeBaseOnDatasource(DataSource datasource) {
        DatabaseType type;
        this.type = type = DatabaseType.find(datasource);
        this.converter = type.getParameterConverter();
    }

    private static HashMap<String, String> combinePropertiesMap(Map<String, String> properties) {
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        propertiesMap.putAll(LogJdbcConfigDefaultProperties.getDefaultPropertiesMap());
        propertiesMap.putAll(properties);
        return propertiesMap;
    }
}

