/*
 * Decompiled with CFR 0.152.
 */
package net.chandol.logjdbc.config;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import net.chandol.logjdbc.config.DatabaseType;
import net.chandol.logjdbc.except.LoggableDataSourceException;

final class DatabaseTypeUtil {
    DatabaseTypeUtil() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String getDatabaseName(DataSource datasource) {
        try (Connection connection = datasource.getConnection();){
            String string = connection.getMetaData().getDatabaseProductName();
            return string;
        }
        catch (SQLException e) {
            throw new LoggableDataSourceException("Error!! fail to find database type", e);
        }
    }

    static DatabaseType findDatabaseType(String databaseName) {
        DatabaseType[] types = DatabaseType.values();
        databaseName = databaseName.toLowerCase();
        for (DatabaseType type : types) {
            for (String matchName : type.matchNames) {
                if (!databaseName.startsWith(matchName.toLowerCase())) continue;
                return type;
            }
        }
        return DatabaseType.UNKNOWN;
    }
}

