/*
 * Decompiled with CFR 0.152.
 */
package net.chandol.logjdbc.config;

import javax.sql.DataSource;
import net.chandol.logjdbc.config.DatabaseInstanceHolder;
import net.chandol.logjdbc.config.DatabaseTypeUtil;
import net.chandol.logjdbc.logging.printer.sql.paramconverter.BaseParameterConverter;
import net.chandol.logjdbc.logging.printer.sql.paramconverter.MysqlParameterConverter;
import net.chandol.logjdbc.logging.printer.sql.paramconverter.OracleParameterConverter;
import net.chandol.logjdbc.logging.printer.sql.paramconverter.ParameterConverter;

public enum DatabaseType {
    H2(BaseParameterConverter.class, "H2"),
    MYSQL(MysqlParameterConverter.class, "MySql", "MariaDB"),
    ORACLE(OracleParameterConverter.class, "Oracle"),
    UNKNOWN(BaseParameterConverter.class, new String[0]);

    String[] matchNames;
    Class<? extends ParameterConverter> converterClass;

    private DatabaseType(Class<? extends ParameterConverter> converterClass, String ... matchNames) {
        this.converterClass = converterClass;
        this.matchNames = matchNames;
    }

    public ParameterConverter getParameterConverter() {
        return DatabaseInstanceHolder.getParameterConverterInstance(this);
    }

    public static DatabaseType find(DataSource datasource) {
        String databaseName = DatabaseTypeUtil.getDatabaseName(datasource);
        return DatabaseTypeUtil.findDatabaseType(databaseName);
    }
}

