/*
 * Decompiled with CFR 0.152.
 */
package net.chandol.logjdbc.config;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.chandol.logjdbc.config.DatabaseType;
import net.chandol.logjdbc.except.LoggableDataSourceException;
import net.chandol.logjdbc.logging.printer.sql.paramconverter.ParameterConverter;

final class DatabaseInstanceHolder {
    private static final Map<DatabaseType, ParameterConverter> instanceHolder = new ConcurrentHashMap<DatabaseType, ParameterConverter>();

    DatabaseInstanceHolder() {
    }

    static synchronized ParameterConverter getParameterConverterInstance(DatabaseType type) {
        if (!instanceHolder.containsKey((Object)type)) {
            try {
                ParameterConverter converter = type.converterClass.newInstance();
                instanceHolder.put(type, converter);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new LoggableDataSourceException(e);
            }
        }
        return instanceHolder.get((Object)type);
    }
}

