/*
 * Decompiled with CFR 0.152.
 */
package net.chandol.logjdbc;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;
import net.chandol.logjdbc.config.LogJdbcConfig;
import net.chandol.logjdbc.jdbcproxy.ProxyConnection;

public class LogJdbcDataSource
implements DataSource {
    private DataSource _datasource;
    private LogJdbcConfig config;

    public LogJdbcDataSource(DataSource dataSource) {
        this._datasource = dataSource;
        this.config = new LogJdbcConfig();
    }

    public LogJdbcDataSource(DataSource dataSource, LogJdbcConfig config) {
        this._datasource = dataSource;
        this.config = config;
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.databaseTypeNotExist()) {
            this.config.setDatabaseTypeBaseOnDatasource(this._datasource);
        }
        return new ProxyConnection(this.config, this._datasource.getConnection());
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        if (this.databaseTypeNotExist()) {
            this.config.setDatabaseTypeBaseOnDatasource(this._datasource);
        }
        return new ProxyConnection(this.config, this._datasource.getConnection(username, password));
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this._datasource.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this._datasource.isWrapperFor(iface);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this._datasource.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this._datasource.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this._datasource.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this._datasource.getLoginTimeout();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this._datasource.getParentLogger();
    }

    private boolean databaseTypeNotExist() {
        return this.config.getType() == null;
    }
}

