package net.chandol.logjdbc.jdbcproxy;

import net.chandol.logjdbc.logging.LogContext;

import java.sql.*;

public class ProxyStatement implements Statement {
    private Statement _stmt;
    protected LogContext context;

    public ProxyStatement(LogContext context, Statement statement) {
        this.context = context;
        this._stmt = statement;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        try {
            context.setSql(sql);
            ResultSet resultSet = _stmt.executeQuery(sql);
            return new ProxyResultSet(context, resultSet);
        } catch (SQLException e) {
            context.printLog();
            throw e;
        }
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        try {
            context.setSql(sql);
            _stmt.addBatch(sql);
        } finally {
            context.printLog();
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        try {
            context.setSql(sql);
            return _stmt.executeUpdate(sql);
        } finally {
            context.printLog();
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        try {
            context.setSql(sql);
            return _stmt.execute(sql);
        } finally {
            context.printLog();
        }
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            //TODO autoGeneratedKeys 분석하기.
            context.setSql(sql);
            return _stmt.executeUpdate(sql, autoGeneratedKeys);
        } finally {
            context.printLog();
        }
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        try {
            context.setSql(sql);
            return _stmt.executeUpdate(sql, columnIndexes);
        } finally {
            context.printLog();
        }
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        try {
            context.setSql(sql);
            return _stmt.executeUpdate(sql, columnNames);
        } finally {
            context.printLog();
        }
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            context.setSql(sql);
            return _stmt.execute(sql, autoGeneratedKeys);
        } finally {
            context.printLog();
        }
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        try {
            context.setSql(sql);
            return _stmt.execute(sql, columnIndexes);
        } finally {
            context.printLog();
        }
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        try {
            context.setSql(sql);
            return _stmt.execute(sql, columnNames);
        } finally {
            context.printLog();
        }
    }


    public void close() throws SQLException {
        _stmt.close();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return _stmt.getMaxFieldSize();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        _stmt.setMaxFieldSize(max);
    }

    @Override
    public int getMaxRows() throws SQLException {
        return _stmt.getMaxRows();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        _stmt.setMaxRows(max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        _stmt.setEscapeProcessing(enable);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return _stmt.getQueryTimeout();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        _stmt.setQueryTimeout(seconds);
    }

    @Override
    public void cancel() throws SQLException {
        _stmt.cancel();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return _stmt.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        _stmt.clearWarnings();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        _stmt.setCursorName(name);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return _stmt.getResultSet();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return _stmt.getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return _stmt.getMoreResults();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        _stmt.setFetchDirection(direction);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return _stmt.getFetchDirection();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        _stmt.setFetchSize(rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return _stmt.getFetchSize();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return _stmt.getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return _stmt.getResultSetType();
    }


    @Override
    public void clearBatch() throws SQLException {
        _stmt.clearBatch();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return _stmt.executeBatch();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return _stmt.getConnection();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return _stmt.getMoreResults(current);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return _stmt.getGeneratedKeys();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return _stmt.getResultSetHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return _stmt.isClosed();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        _stmt.setPoolable(poolable);
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return _stmt.isPoolable();
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        _stmt.closeOnCompletion();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return _stmt.isCloseOnCompletion();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return _stmt.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return _stmt.isWrapperFor(iface);
    }

}