/*
 * Decompiled with CFR 0.152.
 */
package net.cattaka.util.methodhttpexporter.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HttpServer {
    List<ClientThread> clientThreads = Collections.synchronizedList(new ArrayList());
    Map<String, IAction> actionMap = new HashMap<String, IAction>();

    public static void main(String[] args) throws IOException {
        HttpServer httpServer = new HttpServer();
        httpServer.run(8080);
    }

    public void run(int port) throws IOException {
        ServerSocket serverSocket = new ServerSocket(port);
        AcceptThread acceptThread = new AcceptThread(serverSocket);
        acceptThread.start();
    }

    public void addAction(IAction action) {
        this.actionMap.put("/" + action.getActionNames(), action);
    }

    String runAction(Request request) {
        IAction action = this.actionMap.get(request.path);
        if (action == null) {
            return null;
        }
        String[] params = new String[action.getParamNames().length];
        for (int i = 0; i < params.length; ++i) {
            params[i] = request.params.get(action.getParamNames()[i]);
        }
        return action.action(params);
    }

    Request parseParam(String requestLine) {
        String path;
        String[] tmps = requestLine.split(" +");
        if (tmps.length < 3) {
            return null;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        int n = tmps[1].indexOf(63);
        if (n >= 0) {
            String[] paramsStr;
            path = tmps[1].substring(0, n);
            String paramsBlock = tmps[1].substring(n + 1, tmps[1].length());
            for (String paramStr : paramsStr = paramsBlock.split("&")) {
                String[] ts = paramStr.split("=", 2);
                params.put(ts[0], ts.length >= 2 ? ts[1] : "");
            }
        } else {
            path = tmps[1];
        }
        return new Request(path, params);
    }

    public static class Request {
        public String path;
        public Map<String, String> params;

        public Request(String path, Map<String, String> params) {
            this.path = path;
            this.params = params;
        }

        public String toString() {
            return "Request [path=" + this.path + ", params=" + this.params + "]";
        }
    }

    class ClientThread
    extends Thread {
        Socket socket;

        public ClientThread(Socket socket) {
            this.socket = socket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Request request;
                String nextLine;
                BufferedReader in = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), "UTF8"));
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), "UTF8"));
                String requestLine = in.readLine();
                while ((nextLine = in.readLine()) != null && nextLine.length() != 0) {
                }
                Request request2 = request = requestLine != null ? HttpServer.this.parseParam(requestLine) : null;
                if (request != null) {
                    String responseBody = HttpServer.this.runAction(request);
                    if (responseBody != null) {
                        writer.write("HTTP/1.1 200 OK\r\nConnection: close\r\nContent-Type: text/html; charset=UTF-8\r\n\r\n");
                        writer.write(responseBody);
                    } else {
                        writer.write("HTTP/1.1 404 Not found\r\nConnection: close\r\nContent-Type: text/html; charset=UTF-8\r\n\r\n");
                        writer.write("Not found");
                    }
                    writer.flush();
                }
            }
            catch (IOException e) {
            }
            finally {
                try {
                    this.socket.close();
                }
                catch (IOException e) {}
            }
            HttpServer.this.clientThreads.remove(this);
        }
    }

    class AcceptThread
    extends Thread {
        volatile boolean stopFlag = false;
        ServerSocket serverSocket;

        public AcceptThread(ServerSocket serverSocket) {
            this.serverSocket = serverSocket;
        }

        @Override
        public void run() {
            while (!this.stopFlag) {
                try {
                    Socket socket = this.serverSocket.accept();
                    ClientThread clientThread = new ClientThread(socket);
                    HttpServer.this.clientThreads.add(clientThread);
                    clientThread.start();
                }
                catch (IOException e) {}
            }
        }

        public void requestStop() {
            this.stopFlag = true;
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static interface IAction {
        public String getActionNames();

        public String[] getParamNames();

        public String action(String ... var1);
    }
}

