/*
 * Decompiled with CFR 0.152.
 */
package net.caladesiframework.orientdb.graph.repository;

import com.orientechnologies.orient.core.command.OCommandPredicate;
import com.orientechnologies.orient.core.command.traverse.OTraverse;
import com.orientechnologies.orient.core.db.graph.OGraphDatabase;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.ArrayList;
import java.util.List;
import net.caladesiframework.orientdb.field.Field;
import net.caladesiframework.orientdb.graph.OrientGraphRepository;
import net.caladesiframework.orientdb.graph.entity.GraphEntity;
import net.caladesiframework.orientdb.graph.entity.OrientGraphEntity;
import net.caladesiframework.orientdb.graph.repository.EdgeHandler;
import net.caladesiframework.orientdb.graph.repository.SingleRelationCommand;
import net.caladesiframework.orientdb.relation.OptionalRelatedToOne;
import net.caladesiframework.orientdb.relation.RelatedToMany;
import net.caladesiframework.orientdb.relation.RelatedToOne;
import net.caladesiframework.orientdb.relation.Relation;
import net.caladesiframework.orientdb.repository.RepositoryRegistry$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;

public abstract class EdgeHandler$class {
    public static Object checkEdgeType(EdgeHandler $this, RelatedToOne field, OGraphDatabase db) {
        String name = EdgeHandler$class.net$caladesiframework$orientdb$graph$repository$EdgeHandler$$edgeName($this, field);
        OClass oClass = db.getEdgeType(name);
        Object object = oClass != null ? BoxedUnit.UNIT : db.createEdgeType(name);
        return object;
    }

    public static String net$caladesiframework$orientdb$graph$repository$EdgeHandler$$edgeName(EdgeHandler $this, Field field) {
        return new StringBuilder().append((Object)field.owner().clazz()).append((Object)"_").append((Object)((Relation)((Object)field)).relType()).append((Object)"_").append((Object)field.name()).append((Object)"_EDGE").toString();
    }

    public static Object handleRelation(EdgeHandler $this, ODocument vertex, Relation field, OGraphDatabase db) {
        block5: {
            Object object;
            block3: {
                Relation relation;
                block4: {
                    block2: {
                        relation = field;
                        if (!(relation instanceof RelatedToOne)) break block2;
                        RelatedToOne relatedToOne = (RelatedToOne)relation;
                        object = $this.handleRelatedToOne(vertex, relatedToOne, db);
                        break block3;
                    }
                    if (!(relation instanceof OptionalRelatedToOne)) break block4;
                    OptionalRelatedToOne optionalRelatedToOne = (OptionalRelatedToOne)relation;
                    object = $this.handleOptionalRelatedToOne(vertex, optionalRelatedToOne, db);
                    break block3;
                }
                if (!(relation instanceof RelatedToMany)) break block5;
                object = BoxedUnit.UNIT;
            }
            return object;
        }
        throw new Exception("Can't handle this relation type");
    }

    public static String[] handleRelatedToOne(EdgeHandler $this, ODocument vertex, RelatedToOne field, OGraphDatabase db) {
        boolean bl = ((GraphEntity)field.is()).hasInternalId();
        if (bl) {
            Set edges = (Set)JavaConverters$.MODULE$.asScalaSetConverter(db.getOutEdges((OIdentifiable)vertex)).asScala();
            ODocument targetVertex = (ODocument)db.load(((OrientGraphEntity)field.is()).getUnderlyingVertex().getIdentity());
            String relationshipName = EdgeHandler$class.net$caladesiframework$orientdb$graph$repository$EdgeHandler$$edgeName($this, field);
            edges.foreach((Function1)new Serializable($this, relationshipName, vertex, db){
                public static final long serialVersionUID = 0L;
                private final String relationshipName$1;
                private final ODocument vertex$1;
                private final OGraphDatabase db$1;

                /*
                 * Enabled aggressive block sorting
                 */
                public final void apply(OIdentifiable entry) {
                    OIdentifiable oIdentifiable = entry;
                    if (oIdentifiable instanceof ODocument) {
                        ODocument oDocument = (ODocument)oIdentifiable;
                        String string = oDocument.getClassName();
                        String string2 = this.relationshipName$1;
                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Removing oDoc %s for relationShip %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{oDocument.getIdentity().toString(), this.relationshipName$1})));
                            this.db$1.removeEdge((OIdentifiable)oDocument);
                            Predef$.MODULE$.println((Object)this.vertex$1.toJSON());
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                {
                    this.relationshipName$1 = relationshipName$1;
                    this.vertex$1 = vertex$1;
                    this.db$1 = db$1;
                }
            });
            db.getLevel1Cache().invalidate();
            if (vertex.getIdentity().isValid()) {
                // empty if block
            }
            ODocument edge = db.createEdge(vertex, targetVertex, relationshipName);
            edge.save();
            Set edgesForCleanUp = (Set)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(db.getOutEdges((OIdentifiable)vertex)).asScala()).map((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final Object apply(OIdentifiable edge) {
                    return edge == null ? BoxedUnit.UNIT : edge;
                }
            }, Set$.MODULE$.canBuildFrom());
            Predef$.MODULE$.println((Object)edges.mkString("---"));
            String[] stringArray = vertex.getDirtyFields();
            return stringArray;
        }
        throw new Exception("Please update the related entity first");
    }

    public static Object handleOptionalRelatedToOne(EdgeHandler $this, ODocument vertex, OptionalRelatedToOne field, OGraphDatabase db) {
        BoxedUnit boxedUnit;
        String edgeClassName = EdgeHandler$class.net$caladesiframework$orientdb$graph$repository$EdgeHandler$$edgeName($this, field);
        OrientGraphEntity fieldWellFormed = (OrientGraphEntity)((Object)field);
        Iterable edges = EdgeHandler$class.getEdgesBetweenVerticesByName($this, vertex, fieldWellFormed.getUnderlyingVertex(), edgeClassName, db);
        if (edges.size() > 0) {
            if (field.markedToBeRemoved()) {
                edges.foreach((Function1)new Serializable($this, db){
                    public static final long serialVersionUID = 0L;
                    private final OGraphDatabase db$2;

                    public final boolean apply(OIdentifiable edge) {
                        return this.db$2.removeEdge(edge);
                    }
                    {
                        this.db$2 = db$2;
                    }
                });
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            ODocument edge = db.createEdge(vertex, ((OrientGraphEntity)field.is()).getUnderlyingVertex(), edgeClassName);
            boxedUnit = edge.save();
        }
        return boxedUnit;
    }

    public static void loadRelation(EdgeHandler $this, Field field, ODocument vertex, int depth, OGraphDatabase db) {
        OTraverse traversal = new OTraverse().field((Object)"out").target(new OIdentifiable[]{vertex}).predicate((OCommandPredicate)new SingleRelationCommand());
        List result = traversal.execute();
        ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(result).asScala()).withFilter((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(OIdentifiable check$ifrefutable$1) {
                OIdentifiable oIdentifiable = check$ifrefutable$1;
                boolean bl = oIdentifiable != null;
                return bl;
            }
        }).foreach((Function1)new Serializable($this, field, depth, db){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EdgeHandler $outer;
            private final Field field$1;
            private final int depth$1;
            private final OGraphDatabase db$3;

            public final void apply(OIdentifiable identifiable) {
                String string;
                String string2 = ((ODocument)identifiable).getSchemaClass().toString();
                if (string2 != null && (string = string2).equals(EdgeHandler$class.net$caladesiframework$orientdb$graph$repository$EdgeHandler$$edgeName(this.$outer, this.field$1))) {
                    ODocument targetVertex = (ODocument)((ODocument)identifiable).field("in");
                    OrientGraphRepository<EntityType> targetRepo = RepositoryRegistry$.MODULE$.get(((OrientGraphEntity)this.field$1.defaultValue()).clazz());
                    this.field$1.set(targetRepo.createFromVertex(targetVertex, this.depth$1, this.db$3));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.field$1 = field$1;
                this.depth$1 = depth$1;
                this.db$3 = db$3;
            }
        });
    }

    public static int loadRelation$default$3(EdgeHandler $this) {
        return 0;
    }

    private static Iterable getEdgesBetweenVerticesByName(EdgeHandler $this, ODocument source, ODocument target, String name, OGraphDatabase db) {
        ArrayList labels = new ArrayList();
        ArrayList<String> relation = new ArrayList<String>();
        relation.add(name);
        return (Iterable)JavaConverters$.MODULE$.asScalaSetConverter(db.getEdgesBetweenVertexes((OIdentifiable)source, (OIdentifiable)target, (String[])labels, (String[])relation)).asScala();
    }

    public static void $init$(EdgeHandler $this) {
    }
}

