/*
 * Decompiled with CFR 0.152.
 */
package net.caladesiframework.neo4j.relation;

import net.caladesiframework.neo4j.db.Neo4jDatabaseService;
import net.caladesiframework.neo4j.entity.Entity;
import net.caladesiframework.neo4j.field.Field;
import net.caladesiframework.neo4j.graph.entity.GraphEntity;
import net.caladesiframework.neo4j.graph.entity.Neo4jGraphEntity;
import net.caladesiframework.neo4j.graph.repository.Neo4jGraphRepository;
import net.caladesiframework.neo4j.relation.OptionalRelatedToOne;
import net.caladesiframework.neo4j.relation.RelatedToMany;
import net.caladesiframework.neo4j.relation.RelatedToOne;
import net.caladesiframework.neo4j.relation.Relation;
import net.caladesiframework.neo4j.relation.RelationManager;
import net.caladesiframework.neo4j.repository.RepositoryRegistry$;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class RelationManager$class {
    private static String relationName(RelationManager $this, Field field) {
        return ((Relation)((Object)field)).relName();
    }

    public static Object handleRelation(RelationManager $this, Node node, Relation field, Neo4jDatabaseService db) {
        block5: {
            Object object;
            block3: {
                Relation relation;
                block4: {
                    block2: {
                        relation = field;
                        if (!(relation instanceof RelatedToMany)) break block2;
                        $this.handleRelatedToMany(node, (RelatedToMany)relation, db);
                        object = BoxedUnit.UNIT;
                        break block3;
                    }
                    if (!(relation instanceof RelatedToOne)) break block4;
                    object = $this.handleRelatedToOne(node, (RelatedToOne)relation, db);
                    break block3;
                }
                if (!(relation instanceof OptionalRelatedToOne)) break block5;
                object = $this.handleOptionalRelatedToOne(node, (OptionalRelatedToOne)relation, db);
            }
            return object;
        }
        throw new Exception("Can't handle this relation type");
    }

    public static Object handleRelatedToOne(RelationManager $this, Node node, Field field, Neo4jDatabaseService db) {
        DynamicRelationshipType relType = DynamicRelationshipType.withName((String)RelationManager$class.relationName($this, field));
        boolean bl = ((GraphEntity)field.is()).hasInternalId();
        if (bl) {
            Iterable relations = node.getRelationships((RelationshipType)relType, Direction.OUTGOING);
            boolean alreadyPresent = false;
            while (relations.iterator().hasNext()) {
                Relationship relation = (Relationship)relations.iterator().next();
                if (relation.getEndNode().getId() != ((Neo4jGraphEntity)field.is()).getUnderlyingNode().getId()) {
                    relation.delete();
                    continue;
                }
                alreadyPresent = true;
            }
            return alreadyPresent ? BoxedUnit.UNIT : node.createRelationshipTo(((Neo4jGraphEntity)field.is()).getUnderlyingNode(), (RelationshipType)relType);
        }
        throw new Exception("Please update the related entity first");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object handleOptionalRelatedToOne(RelationManager $this, Node node, OptionalRelatedToOne field, Neo4jDatabaseService db) {
        Object object;
        DynamicRelationshipType relType = DynamicRelationshipType.withName((String)RelationManager$class.relationName($this, field));
        Object t = field.is();
        None$ none$ = None$.MODULE$;
        if ((t == null ? none$ != null : !t.equals(none$)) && ((GraphEntity)((Option)field.is()).get()).hasInternalId()) {
            boolean bl = ((GraphEntity)((Option)field.is()).get()).hasInternalId();
            if (!bl) throw new Exception("Please update the (optional) related entity first");
            Iterable relations = node.getRelationships((RelationshipType)relType, Direction.OUTGOING);
            boolean alreadyPresent = false;
            while (relations.iterator().hasNext()) {
                Relationship relation = (Relationship)relations.iterator().next();
                if (relation.getEndNode().getId() != ((Neo4jGraphEntity)((Option)field.is()).get()).getUnderlyingNode().getId()) {
                    relation.delete();
                    continue;
                }
                alreadyPresent = true;
            }
            object = alreadyPresent ? BoxedUnit.UNIT : node.createRelationshipTo(((Neo4jGraphEntity)((Option)field.is()).get()).getUnderlyingNode(), (RelationshipType)relType);
            return object;
        } else {
            Iterable relations = node.getRelationships((RelationshipType)relType, Direction.OUTGOING);
            while (relations.iterator().hasNext()) {
                Relationship relation = (Relationship)relations.iterator().next();
                relation.delete();
            }
            object = BoxedUnit.UNIT;
        }
        return object;
    }

    public static void handleRelatedToMany(RelationManager $this, Node node$1, RelatedToMany field, Neo4jDatabaseService db) {
        DynamicRelationshipType relType$1 = DynamicRelationshipType.withName((String)RelationManager$class.relationName($this, field));
        HashMap alreadyPresent$1 = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        Iterable relations = node$1.getRelationships((RelationshipType)relType$1, Direction.OUTGOING);
        while (relations.iterator().hasNext()) {
            BoxedUnit boxedUnit;
            Relationship relation = (Relationship)relations.iterator().next();
            if (((MapLike)field.is()).contains((Object)BoxesRunTime.boxToLong((long)relation.getEndNode().getId()))) {
                boxedUnit = alreadyPresent$1.put((Object)BoxesRunTime.boxToLong((long)relation.getEndNode().getId()), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                continue;
            }
            relation.delete();
            boxedUnit = BoxedUnit.UNIT;
        }
        ((HashMap)field.is()).foreach((Function1)new Serializable($this, node$1, relType$1, alreadyPresent$1){
            public static final long serialVersionUID;
            private final Node node$1;
            private final DynamicRelationshipType relType$1;
            private final HashMap alreadyPresent$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Object apply(Tuple2<Object, RelatedEntityType> entry) {
                return this.alreadyPresent$1.contains((Object)BoxesRunTime.boxToLong((long)entry._1$mcJ$sp())) ? BoxedUnit.UNIT : this.node$1.createRelationshipTo(((Neo4jGraphEntity)entry._2()).getUnderlyingNode(), (RelationshipType)this.relType$1);
            }
            {
                this.node$1 = node;
                this.relType$1 = dynamicRelationshipType;
                this.alreadyPresent$1 = hashMap;
            }
        });
    }

    public static void loadRelation(RelationManager $this, Field field, Node node, int depth, Neo4jDatabaseService db) {
        Field field2;
        block9: {
            block7: {
                RelatedToOne relatedToOne;
                DynamicRelationshipType relType;
                block8: {
                    OptionalRelatedToOne optionalRelatedToOne;
                    block6: {
                        RelatedToMany relatedToMany;
                        relType = DynamicRelationshipType.withName((String)RelationManager$class.relationName($this, field));
                        field2 = field;
                        if (!(field2 instanceof RelatedToMany)) break block6;
                        RelatedToMany fld = relatedToMany = (RelatedToMany)field2;
                        Neo4jGraphRepository targetRepo = RepositoryRegistry$.MODULE$.get(((Entity)fld.targetClazz()).clazz());
                        Iterable relations = node.getRelationships((RelationshipType)relType, Direction.OUTGOING);
                        while (relations.iterator().hasNext()) {
                            Relationship relation = (Relationship)relations.iterator().next();
                            fld.put(targetRepo.createFromNode(relation.getEndNode(), depth, db));
                        }
                        break block7;
                    }
                    if (!(field2 instanceof OptionalRelatedToOne)) break block8;
                    OptionalRelatedToOne fld = optionalRelatedToOne = (OptionalRelatedToOne)field2;
                    Relationship rel = node.getSingleRelationship((RelationshipType)relType, Direction.OUTGOING);
                    if (rel == null) {
                        fld.clear();
                    } else {
                        Neo4jGraphRepository targetRepo = RepositoryRegistry$.MODULE$.get(((Entity)fld.targetClazz()).clazz());
                        fld.set(targetRepo.createFromNode(rel.getEndNode(), depth, db));
                    }
                    break block7;
                }
                if (!(field2 instanceof RelatedToOne)) break block9;
                RelatedToOne fld = relatedToOne = (RelatedToOne)field2;
                Relationship rel = node.getSingleRelationship((RelationshipType)relType, Direction.OUTGOING);
                Neo4jGraphRepository targetRepo = RepositoryRegistry$.MODULE$.get(((Entity)fld.defaultValue()).clazz());
                field.set(targetRepo.createFromNode(rel.getEndNode(), depth, db));
            }
            return;
        }
        throw new MatchError((Object)field2);
    }

    public static int loadRelation$default$3(RelationManager $this) {
        return 0;
    }

    public static void $init$(RelationManager $this) {
    }
}

